/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.portlet.PortletContext;
import org.springframework.core.io.AbstractFileResolvingResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.portlet.util.PortletUtils;

public class PortletContextResource
extends AbstractFileResolvingResource
implements ContextResource {
    private final PortletContext portletContext;
    private final String path;

    public PortletContextResource(PortletContext portletContext, String path) {
        Assert.notNull((Object)portletContext, (String)"Cannot resolve PortletContextResource without PortletContext");
        this.portletContext = portletContext;
        Assert.notNull((Object)path, (String)"Path is required");
        String pathToUse = StringUtils.cleanPath((String)path);
        if (!pathToUse.startsWith("/")) {
            pathToUse = "/" + pathToUse;
        }
        this.path = pathToUse;
    }

    public final PortletContext getPortletContext() {
        return this.portletContext;
    }

    public final String getPath() {
        return this.path;
    }

    public boolean exists() {
        try {
            URL url = this.portletContext.getResource(this.path);
            return url != null;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public boolean isReadable() {
        InputStream is = this.portletContext.getResourceAsStream(this.path);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.portletContext.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return is;
    }

    public URL getURL() throws IOException {
        URL url = this.portletContext.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    public File getFile() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isFileURL((URL)url)) {
            return super.getFile();
        }
        String realPath = PortletUtils.getRealPath(this.portletContext, this.path);
        return new File(realPath);
    }

    public Resource createRelative(String relativePath) {
        String pathToUse = StringUtils.applyRelativePath((String)this.path, (String)relativePath);
        return new PortletContextResource(this.portletContext, pathToUse);
    }

    public String getFilename() {
        return StringUtils.getFilename((String)this.path);
    }

    public String getDescription() {
        return "PortletContext resource [" + this.path + "]";
    }

    public String getPathWithinContext() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PortletContextResource) {
            PortletContextResource otherRes = (PortletContextResource)((Object)obj);
            return this.portletContext.equals(otherRes.portletContext) && this.path.equals(otherRes.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

