/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

class ReadOnlyHttpHeaders
extends HttpHeaders {
    private static final long serialVersionUID = -8578554704772377436L;
    private @Nullable MediaType cachedContentType;
    private @Nullable List<MediaType> cachedAccept;

    ReadOnlyHttpHeaders(MultiValueMap<String, String> headers) {
        super(headers);
    }

    @Override
    public @Nullable MediaType getContentType() {
        MediaType contentType;
        if (this.cachedContentType != null) {
            return this.cachedContentType;
        }
        this.cachedContentType = contentType = super.getContentType();
        return contentType;
    }

    @Override
    public List<MediaType> getAccept() {
        if (this.cachedAccept != null) {
            return this.cachedAccept;
        }
        List<MediaType> accept = super.getAccept();
        this.cachedAccept = accept;
        return accept;
    }

    @Override
    public void clearContentHeaders() {
    }

    @Override
    public @Nullable List<String> get(String headerName) {
        List values = (List)this.headers.get((Object)headerName);
        return values != null ? Collections.unmodifiableList(values) : null;
    }

    @Override
    public void add(String headerName, @Nullable String headerValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(String key, List<? extends String> headerValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(HttpHeaders values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(String headerName, @Nullable String headerValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAll(Map<String, String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        return Collections.unmodifiableMap(this.headers.toSingleValueMap());
    }

    @Override
    @Deprecated(since="7.0", forRemoval=true)
    public Map<String, String> asSingleValueMap() {
        return Collections.unmodifiableMap(this.headers.asSingleValueMap());
    }

    @Override
    @Deprecated(since="7.0", forRemoval=true)
    public MultiValueMap<String, String> asMultiValueMap() {
        return CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)this.headers);
    }

    @Override
    public Set<String> headerNames() {
        return Collections.unmodifiableSet(super.headerNames());
    }

    @Override
    public List<String> put(String key, List<String> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable List<String> putIfAbsent(String headerName, List<String> headerValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nullable HttpHeaders values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> headers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> remove(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> headerSet() {
        return super.headerSet().stream().map(AbstractMap.SimpleImmutableEntry::new).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super List<String>> action) {
        this.headers.forEach((k, vs) -> action.accept((String)k, (List<String>)Collections.unmodifiableList(vs)));
    }
}

