/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.util.StringUtils;

public class StaticListableBeanFactory
implements ListableBeanFactory {
    private final Map beans = new HashMap();

    public void addBean(String name, Object bean) {
        this.beans.put(name, bean);
    }

    public Object getBean(String name) throws BeansException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (BeanFactoryUtils.isFactoryDereference(name) && !(bean instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, bean.getClass());
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name)) {
            try {
                return ((FactoryBean)bean).getObject();
            }
            catch (Exception ex) {
                throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
            }
        }
        return bean;
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        Object bean = this.getBean(name);
        if (requiredType != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return bean;
    }

    public Object getBean(String name, Object[] args) throws BeansException {
        if (args != null) {
            throw new UnsupportedOperationException("StaticListableBeanFactory does not support explicit bean creation arguments)");
        }
        return this.getBean(name);
    }

    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name);
        return bean instanceof FactoryBean && ((FactoryBean)bean).isSingleton();
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name);
        return bean instanceof SmartFactoryBean && ((SmartFactoryBean)bean).isPrototype() || bean instanceof FactoryBean && !((FactoryBean)bean).isSingleton();
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        Class type = this.getType(name);
        return targetType == null || type != null && targetType.isAssignableFrom(type);
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name)) {
            return ((FactoryBean)bean).getObjectType();
        }
        return bean.getClass();
    }

    public String[] getAliases(String name) {
        return new String[0];
    }

    public boolean containsBeanDefinition(String name) {
        return this.beans.containsKey(name);
    }

    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray(this.beans.keySet());
    }

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanNamesForType(type, true, true);
    }

    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean includeFactoryBeans) {
        boolean isFactoryType = type != null && FactoryBean.class.isAssignableFrom(type);
        ArrayList<String> matches = new ArrayList<String>();
        Set keys = this.beans.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object beanInstance = this.beans.get(name);
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                Class objectType;
                if (!includeFactoryBeans || (objectType = ((FactoryBean)beanInstance).getObjectType()) == null || !type.isAssignableFrom(objectType)) continue;
                matches.add(name);
                continue;
            }
            if (!type.isInstance(beanInstance)) continue;
            matches.add(name);
        }
        return StringUtils.toStringArray(matches);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public Map getBeansOfType(Class type, boolean includeNonSingletons, boolean includeFactoryBeans) throws BeansException {
        boolean isFactoryType = type != null && FactoryBean.class.isAssignableFrom(type);
        HashMap<String, Object> matches = new HashMap<String, Object>();
        Iterator it = this.beans.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String beanName = (String)entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                if (!includeFactoryBeans) continue;
                FactoryBean factory = (FactoryBean)beanInstance;
                Class objectType = factory.getObjectType();
                if (!includeNonSingletons && !factory.isSingleton() || objectType == null || !type.isAssignableFrom(objectType)) continue;
                matches.put(beanName, this.getBean(beanName));
                continue;
            }
            if (!type.isInstance(beanInstance)) continue;
            if (isFactoryType) {
                beanName = "&" + beanName;
            }
            matches.put(beanName, beanInstance);
        }
        return matches;
    }
}

