/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.social.UncategorizedApiException;
import org.springframework.social.facebook.api.CommentOperations;
import org.springframework.social.facebook.api.EventOperations;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.api.FeedOperations;
import org.springframework.social.facebook.api.FqlOperations;
import org.springframework.social.facebook.api.FriendOperations;
import org.springframework.social.facebook.api.GroupOperations;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.LikeOperations;
import org.springframework.social.facebook.api.MediaOperations;
import org.springframework.social.facebook.api.OpenGraphOperations;
import org.springframework.social.facebook.api.PageOperations;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.PlacesOperations;
import org.springframework.social.facebook.api.QuestionOperations;
import org.springframework.social.facebook.api.UserOperations;
import org.springframework.social.facebook.api.impl.CommentTemplate;
import org.springframework.social.facebook.api.impl.EventTemplate;
import org.springframework.social.facebook.api.impl.FacebookErrorHandler;
import org.springframework.social.facebook.api.impl.FeedTemplate;
import org.springframework.social.facebook.api.impl.FqlTemplate;
import org.springframework.social.facebook.api.impl.FriendTemplate;
import org.springframework.social.facebook.api.impl.GroupTemplate;
import org.springframework.social.facebook.api.impl.LikeTemplate;
import org.springframework.social.facebook.api.impl.MediaTemplate;
import org.springframework.social.facebook.api.impl.OpenGraphTemplate;
import org.springframework.social.facebook.api.impl.PageTemplate;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.social.facebook.api.impl.PlacesTemplate;
import org.springframework.social.facebook.api.impl.QuestionTemplate;
import org.springframework.social.facebook.api.impl.UserTemplate;
import org.springframework.social.facebook.api.impl.json.FacebookModule;
import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookTemplate
extends AbstractOAuth2ApiBinding
implements Facebook {
    private UserOperations userOperations;
    private PlacesOperations placesOperations;
    private FriendOperations friendOperations;
    private FeedOperations feedOperations;
    private GroupOperations groupOperations;
    private CommentOperations commentOperations;
    private LikeOperations likeOperations;
    private EventOperations eventOperations;
    private MediaOperations mediaOperations;
    private PageOperations pageOperations;
    private FqlOperations fqlOperations;
    private QuestionOperations questionOperations;
    private OpenGraphOperations openGraphOperations;
    private ObjectMapper objectMapper;
    private String applicationNamespace;

    public FacebookTemplate() {
        this.initialize();
    }

    public FacebookTemplate(String accessToken) {
        this(accessToken, null);
    }

    public FacebookTemplate(String accessToken, String applicationNamespace) {
        super(accessToken);
        this.applicationNamespace = applicationNamespace;
        this.initialize();
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        super.setRequestFactory(ClientHttpRequestFactorySelector.bufferRequests((ClientHttpRequestFactory)requestFactory));
    }

    @Override
    public UserOperations userOperations() {
        return this.userOperations;
    }

    @Override
    public PlacesOperations placesOperations() {
        return this.placesOperations;
    }

    @Override
    public LikeOperations likeOperations() {
        return this.likeOperations;
    }

    @Override
    public FriendOperations friendOperations() {
        return this.friendOperations;
    }

    @Override
    public FeedOperations feedOperations() {
        return this.feedOperations;
    }

    @Override
    public GroupOperations groupOperations() {
        return this.groupOperations;
    }

    @Override
    public CommentOperations commentOperations() {
        return this.commentOperations;
    }

    @Override
    public EventOperations eventOperations() {
        return this.eventOperations;
    }

    @Override
    public MediaOperations mediaOperations() {
        return this.mediaOperations;
    }

    @Override
    public PageOperations pageOperations() {
        return this.pageOperations;
    }

    @Override
    public RestOperations restOperations() {
        return this.getRestTemplate();
    }

    @Override
    public FqlOperations fqlOperations() {
        return this.fqlOperations;
    }

    @Override
    public QuestionOperations questionOperations() {
        return this.questionOperations;
    }

    @Override
    public OpenGraphOperations openGraphOperations() {
        return this.openGraphOperations;
    }

    @Override
    public String getApplicationNamespace() {
        return this.applicationNamespace;
    }

    @Override
    public <T> T fetchObject(String objectId, Class<T> type) {
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/v1.0/" + objectId)).build();
        return (T)this.getRestTemplate().getForObject(uri, type);
    }

    @Override
    public <T> T fetchObject(String objectId, Class<T> type, MultiValueMap<String, String> queryParameters) {
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/v1.0/" + objectId)).queryParams(queryParameters).build();
        return (T)this.getRestTemplate().getForObject(uri, type);
    }

    @Override
    public <T> PagedList<T> fetchConnections(String objectId, String connectionType, Class<T> type, String ... fields) {
        LinkedMultiValueMap queryParameters = new LinkedMultiValueMap();
        if (fields.length > 0) {
            String joinedFields = this.join(fields);
            queryParameters.set((Object)"fields", (Object)joinedFields);
        }
        return this.fetchConnections(objectId, connectionType, type, (MultiValueMap<String, String>)queryParameters);
    }

    @Override
    public <T> PagedList<T> fetchConnections(String objectId, String connectionType, Class<T> type, MultiValueMap<String, String> queryParameters) {
        String connectionPath = connectionType != null && connectionType.length() > 0 ? "/" + connectionType : "";
        URIBuilder uriBuilder = URIBuilder.fromUri((String)("https://graph.facebook.com/v1.0/" + objectId + connectionPath)).queryParams(queryParameters);
        JsonNode jsonNode = (JsonNode)this.getRestTemplate().getForObject(uriBuilder.build(), JsonNode.class);
        return this.pagify(type, jsonNode);
    }

    public <T> PagedList<T> fetchPagedConnections(String objectId, String connectionType, Class<T> type, MultiValueMap<String, String> queryParameters) {
        String connectionPath = connectionType != null && connectionType.length() > 0 ? "/" + connectionType : "";
        URIBuilder uriBuilder = URIBuilder.fromUri((String)("https://graph.facebook.com/v1.0/" + objectId + connectionPath)).queryParams(queryParameters);
        JsonNode jsonNode = (JsonNode)this.getRestTemplate().getForObject(uriBuilder.build(), JsonNode.class);
        return this.pagify(type, jsonNode);
    }

    @Override
    public <T> PagedList<T> fetchConnections(String objectId, String connectionType, Class<T> type, MultiValueMap<String, String> queryParameters, String ... fields) {
        if (fields.length > 0) {
            String joinedFields = this.join(fields);
            queryParameters.set((Object)"fields", (Object)joinedFields);
        }
        return this.fetchPagedConnections(objectId, connectionType, type, queryParameters);
    }

    private <T> PagedList<T> pagify(Class<T> type, JsonNode jsonNode) {
        List<T> data = this.deserializeDataList(jsonNode.get("data"), type);
        if (jsonNode.has("paging")) {
            JsonNode pagingNode = jsonNode.get("paging");
            PagingParameters previousPage = PagedListUtils.getPagedListParameters(pagingNode, "previous");
            PagingParameters nextPage = PagedListUtils.getPagedListParameters(pagingNode, "next");
            return new PagedList<T>(data, previousPage, nextPage);
        }
        return new PagedList<T>(data, null, null);
    }

    @Override
    public byte[] fetchImage(String objectId, String connectionType, ImageType type) {
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/v1.0/" + objectId + "/" + connectionType + "?type=" + type.toString().toLowerCase())).build();
        ResponseEntity response = this.getRestTemplate().getForEntity(uri, byte[].class);
        if (response.getStatusCode() == HttpStatus.FOUND) {
            throw new UnsupportedOperationException("Attempt to fetch image resulted in a redirect which could not be followed. Add Apache HttpComponents HttpClient to the classpath to be able to follow redirects.");
        }
        return (byte[])response.getBody();
    }

    @Override
    public String publish(String objectId, String connectionType, MultiValueMap<String, Object> data) {
        LinkedMultiValueMap requestData = new LinkedMultiValueMap(data);
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/v1.0/" + objectId + "/" + connectionType)).build();
        Map response = (Map)this.getRestTemplate().postForObject(uri, (Object)requestData, Map.class);
        return (String)response.get("id");
    }

    @Override
    public void post(String objectId, String connectionType, MultiValueMap<String, String> data) {
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/v1.0/" + objectId + "/" + connectionType)).build();
        this.getRestTemplate().postForObject(uri, (Object)new LinkedMultiValueMap(data), String.class);
    }

    @Override
    public void delete(String objectId) {
        LinkedMultiValueMap deleteRequest = new LinkedMultiValueMap();
        deleteRequest.set((Object)"method", (Object)"delete");
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/v1.0/" + objectId)).build();
        this.getRestTemplate().postForObject(uri, (Object)deleteRequest, String.class);
    }

    @Override
    public void delete(String objectId, String connectionType) {
        LinkedMultiValueMap deleteRequest = new LinkedMultiValueMap();
        deleteRequest.set((Object)"method", (Object)"delete");
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/v1.0/" + objectId + "/" + connectionType)).build();
        this.getRestTemplate().postForObject(uri, (Object)deleteRequest, String.class);
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.DRAFT_10;
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new FacebookErrorHandler());
    }

    protected MappingJackson2HttpMessageConverter getJsonMessageConverter() {
        MappingJackson2HttpMessageConverter converter = super.getJsonMessageConverter();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new FacebookModule());
        converter.setObjectMapper(this.objectMapper);
        return converter;
    }

    private void initialize() {
        super.setRequestFactory(ClientHttpRequestFactorySelector.bufferRequests((ClientHttpRequestFactory)this.getRestTemplate().getRequestFactory()));
        this.initSubApis();
    }

    private void initSubApis() {
        this.openGraphOperations = new OpenGraphTemplate(this, this.isAuthorized());
        this.userOperations = new UserTemplate(this, this.getRestTemplate(), this.isAuthorized());
        this.placesOperations = new PlacesTemplate(this, this.isAuthorized());
        this.friendOperations = new FriendTemplate(this, this.getRestTemplate(), this.isAuthorized());
        this.feedOperations = new FeedTemplate(this, this.getRestTemplate(), this.objectMapper, this.isAuthorized());
        this.commentOperations = new CommentTemplate(this, this.isAuthorized());
        this.likeOperations = new LikeTemplate(this, this.isAuthorized());
        this.eventOperations = new EventTemplate(this, this.isAuthorized());
        this.mediaOperations = new MediaTemplate(this, this.getRestTemplate(), this.isAuthorized());
        this.groupOperations = new GroupTemplate(this, this.isAuthorized());
        this.pageOperations = new PageTemplate(this, this.isAuthorized());
        this.fqlOperations = new FqlTemplate(this, this.isAuthorized());
        this.questionOperations = new QuestionTemplate(this, this.isAuthorized());
    }

    private <T> List<T> deserializeDataList(JsonNode jsonNode, Class<T> elementType) {
        try {
            CollectionType listType = TypeFactory.defaultInstance().constructCollectionType(List.class, elementType);
            return (List)this.objectMapper.reader((JavaType)listType).readValue(jsonNode.toString());
        }
        catch (IOException e) {
            throw new UncategorizedApiException("facebook", "Error deserializing data from Facebook: " + e.getMessage(), (Throwable)e);
        }
    }

    private String join(String[] strings) {
        StringBuilder builder = new StringBuilder();
        if (strings.length > 0) {
            builder.append(strings[0]);
            for (int i = 1; i < strings.length; ++i) {
                builder.append("," + strings[i]);
            }
        }
        return builder.toString();
    }
}

