/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import java.io.IOException;
import java.util.Date;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.facebook.api.Album;
import org.springframework.social.facebook.api.Reference;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class AlbumMixin {
    @JsonProperty(value="location")
    String location;
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="updated_time")
    Date updatedTime;

    @JsonCreator
    AlbumMixin(@JsonProperty(value="id") String id, @JsonProperty(value="from") Reference from, @JsonProperty(value="name") String name, @JsonProperty(value="type") @JsonDeserialize(using=TypeDeserializer.class) Album.Type type, @JsonProperty(value="link") String link, @JsonProperty(value="count") int count, @JsonProperty(value="privacy") @JsonDeserialize(using=PrivacyDeserializer.class) Album.Privacy privacy, @JsonProperty(value="created_time") Date createdTime) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivacyDeserializer
    extends JsonDeserializer<Album.Privacy> {
        private PrivacyDeserializer() {
        }

        public Album.Privacy deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return Album.Privacy.valueOf(jp.getText().replace("-", "_").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return Album.Privacy.CUSTOM;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDeserializer
    extends JsonDeserializer<Album.Type> {
        private TypeDeserializer() {
        }

        public Album.Type deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return Album.Type.valueOf(jp.getText().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return Album.Type.UNKNOWN;
            }
        }
    }
}

