/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ParametersDelegate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ElementDescriptor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.ParameterDescription;
import org.springframework.shell.ParameterResolver;
import org.springframework.shell.Utils;
import org.springframework.shell.ValueResult;
import org.springframework.util.ReflectionUtils;

public class JCommanderParameterResolver
implements ParameterResolver {
    private static final Collection<Class<? extends Annotation>> JCOMMANDER_ANNOTATIONS = Arrays.asList(Parameter.class, DynamicParameter.class, ParametersDelegate.class);
    private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    @Autowired(required=false)
    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    public boolean supports(MethodParameter parameter) {
        AtomicBoolean isSupported = new AtomicBoolean(false);
        Class parameterType = parameter.getParameterType();
        ReflectionUtils.doWithFields((Class)parameterType, field -> {
            ReflectionUtils.makeAccessible((Field)field);
            boolean hasAnnotation = Arrays.stream(field.getAnnotations()).map(Annotation::annotationType).anyMatch(JCOMMANDER_ANNOTATIONS::contains);
            isSupported.compareAndSet(false, hasAnnotation);
        });
        ReflectionUtils.doWithMethods((Class)parameterType, method -> {
            ReflectionUtils.makeAccessible((Method)method);
            boolean hasAnnotation = Arrays.stream(method.getAnnotations()).map(Annotation::annotationType).anyMatch(Parameter.class::equals);
            isSupported.compareAndSet(false, hasAnnotation);
        });
        return isSupported.get();
    }

    public ValueResult resolve(MethodParameter methodParameter, List<String> words) {
        JCommander jCommander = this.createJCommander(methodParameter);
        jCommander.parse(words.toArray(new String[words.size()]));
        return new ValueResult(methodParameter, jCommander.getObjects().get(0));
    }

    private JCommander createJCommander(MethodParameter methodParameter) {
        Object pojo = BeanUtils.instantiateClass((Class)methodParameter.getParameterType());
        JCommander jCommander = new JCommander(pojo);
        jCommander.setAcceptUnknownOptions(true);
        return jCommander;
    }

    public Stream<ParameterDescription> describe(MethodParameter parameter) {
        JCommander jCommander = this.createJCommander(parameter);
        Stream<com.beust.jcommander.ParameterDescription> jCommanderDescriptions = this.streamAllJCommanderDescriptions(jCommander);
        BeanDescriptor constraintsForClass = this.validator.getConstraintsForClass(parameter.getParameterType());
        return jCommanderDescriptions.map(j -> new ParameterDescription(parameter, Utils.unCamelify((CharSequence)j.getParameterized().getType().getSimpleName())).keys(Arrays.asList(j.getParameter().names())).help(j.getDescription()).mandatoryKey(!j.equals(jCommander.getMainParameter())).defaultValue(j.getDefault() == null ? "" : String.valueOf(j.getDefault())).elementDescriptor((ElementDescriptor)constraintsForClass.getConstraintsForProperty(j.getParameterized().getName())));
    }

    private Stream<com.beust.jcommander.ParameterDescription> streamAllJCommanderDescriptions(JCommander jCommander) {
        return Stream.concat(jCommander.getParameters().stream(), jCommander.getMainParameter() != null ? Stream.of(jCommander.getMainParameter()) : Stream.empty());
    }

    public List<CompletionProposal> complete(MethodParameter parameter, CompletionContext context) {
        JCommander jCommander = this.createJCommander(parameter);
        List words = context.getWords();
        try {
            jCommander.parseWithoutValidation(words.toArray(new String[words.size()]));
        }
        catch (ParameterException ignored) {
            return Collections.emptyList();
        }
        return this.streamAllJCommanderDescriptions(jCommander).filter(p -> !p.isAssigned()).flatMap(p -> Arrays.stream(p.getParameter().names())).map(CompletionProposal::new).collect(Collectors.toList());
    }
}

