/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.firewall;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.firewall.FirewalledRequest;
import org.springframework.security.web.firewall.FirewalledResponse;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.security.web.firewall.RequestWrapper;

public class DefaultHttpFirewall
implements HttpFirewall {
    @Override
    public FirewalledRequest getFirewalledRequest(HttpServletRequest request) throws RequestRejectedException {
        RequestWrapper fwr = new RequestWrapper(request);
        if (!this.isNormalized(fwr.getServletPath()) || !this.isNormalized(fwr.getPathInfo())) {
            throw new RequestRejectedException("Un-normalized paths are not supported: " + fwr.getServletPath() + (fwr.getPathInfo() != null ? fwr.getPathInfo() : ""));
        }
        return fwr;
    }

    @Override
    public HttpServletResponse getFirewalledResponse(HttpServletResponse response) {
        return new FirewalledResponse(response);
    }

    private boolean isNormalized(String path) {
        if (path == null) {
            return true;
        }
        int j = path.length();
        while (j > 0) {
            int i = path.lastIndexOf(47, j - 1);
            int gap = j - i;
            if (gap == 2 && path.charAt(i + 1) == '.') {
                return false;
            }
            if (gap == 3 && path.charAt(i + 1) == '.' && path.charAt(i + 2) == '.') {
                return false;
            }
            j = i;
        }
        return true;
    }
}

