/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OAuth2ClientCredentialsGrantRequest
extends AbstractOAuth2AuthorizationGrantRequest {
    public OAuth2ClientCredentialsGrantRequest(ClientRegistration clientRegistration) {
        super(AuthorizationGrantType.CLIENT_CREDENTIALS, clientRegistration);
        Assert.isTrue((boolean)AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)clientRegistration.getAuthorizationGrantType()), (String)"clientRegistration.authorizationGrantType must be AuthorizationGrantType.CLIENT_CREDENTIALS");
    }

    static MultiValueMap<String, String> defaultParameters(OAuth2ClientCredentialsGrantRequest grantRequest) {
        ClientRegistration clientRegistration = grantRequest.getClientRegistration();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            parameters.set((Object)"scope", (Object)StringUtils.collectionToDelimitedString(clientRegistration.getScopes(), (String)" "));
        }
        return parameters;
    }
}

