/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.jackson2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Set;

abstract class JsonNodeUtils {
    static final TypeReference<Set<String>> SET_TYPE_REFERENCE = new TypeReference<Set<String>>(){};
    static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    JsonNodeUtils() {
    }

    static String findStringValue(JsonNode jsonNode, String fieldName) {
        if (jsonNode == null) {
            return null;
        }
        JsonNode nodeValue = jsonNode.findValue(fieldName);
        if (nodeValue != null && nodeValue.isTextual()) {
            return nodeValue.asText();
        }
        return null;
    }

    static <T> T findValue(JsonNode jsonNode, String fieldName, TypeReference<T> valueTypeReference, ObjectMapper mapper) {
        if (jsonNode == null) {
            return null;
        }
        JsonNode nodeValue = jsonNode.findValue(fieldName);
        if (nodeValue != null && nodeValue.isContainerNode()) {
            return (T)mapper.convertValue((Object)nodeValue, valueTypeReference);
        }
        return null;
    }

    static JsonNode findObjectNode(JsonNode jsonNode, String fieldName) {
        if (jsonNode == null) {
            return null;
        }
        JsonNode nodeValue = jsonNode.findValue(fieldName);
        if (nodeValue != null && nodeValue.isObject()) {
            return nodeValue;
        }
        return null;
    }
}

