/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.PermitAllSupport;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.DelegatingLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class LogoutConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<LogoutConfigurer<H>, H> {
    private List<LogoutHandler> logoutHandlers = new ArrayList<LogoutHandler>();
    private SecurityContextLogoutHandler contextLogoutHandler = new SecurityContextLogoutHandler();
    private String logoutSuccessUrl = "/login?logout";
    private LogoutSuccessHandler logoutSuccessHandler;
    private String logoutUrl = "/logout";
    private RequestMatcher logoutRequestMatcher;
    private boolean permitAll;
    private boolean customLogoutSuccess;
    private LinkedHashMap<RequestMatcher, LogoutSuccessHandler> defaultLogoutSuccessHandlerMappings = new LinkedHashMap();

    public LogoutConfigurer<H> addLogoutHandler(LogoutHandler logoutHandler) {
        Assert.notNull((Object)logoutHandler, (String)"logoutHandler cannot be null");
        this.logoutHandlers.add(logoutHandler);
        return this;
    }

    public LogoutConfigurer<H> clearAuthentication(boolean clearAuthentication) {
        this.contextLogoutHandler.setClearAuthentication(clearAuthentication);
        return this;
    }

    public LogoutConfigurer<H> invalidateHttpSession(boolean invalidateHttpSession) {
        this.contextLogoutHandler.setInvalidateHttpSession(invalidateHttpSession);
        return this;
    }

    public LogoutConfigurer<H> logoutUrl(String logoutUrl) {
        this.logoutRequestMatcher = null;
        this.logoutUrl = logoutUrl;
        return this;
    }

    public LogoutConfigurer<H> logoutRequestMatcher(RequestMatcher logoutRequestMatcher) {
        this.logoutRequestMatcher = logoutRequestMatcher;
        return this;
    }

    public LogoutConfigurer<H> logoutSuccessUrl(String logoutSuccessUrl) {
        this.customLogoutSuccess = true;
        this.logoutSuccessUrl = logoutSuccessUrl;
        return this;
    }

    public LogoutConfigurer<H> permitAll() {
        return this.permitAll(true);
    }

    public LogoutConfigurer<H> deleteCookies(String ... cookieNamesToClear) {
        return this.addLogoutHandler((LogoutHandler)new CookieClearingLogoutHandler(cookieNamesToClear));
    }

    public LogoutConfigurer<H> logoutSuccessHandler(LogoutSuccessHandler logoutSuccessHandler) {
        this.logoutSuccessUrl = null;
        this.customLogoutSuccess = true;
        this.logoutSuccessHandler = logoutSuccessHandler;
        return this;
    }

    public LogoutConfigurer<H> defaultLogoutSuccessHandlerFor(LogoutSuccessHandler handler, RequestMatcher preferredMatcher) {
        Assert.notNull((Object)handler, (String)"handler cannot be null");
        Assert.notNull((Object)preferredMatcher, (String)"preferredMatcher cannot be null");
        this.defaultLogoutSuccessHandlerMappings.put(preferredMatcher, handler);
        return this;
    }

    public LogoutConfigurer<H> permitAll(boolean permitAll) {
        this.permitAll = permitAll;
        return this;
    }

    private LogoutSuccessHandler getLogoutSuccessHandler() {
        LogoutSuccessHandler handler = this.logoutSuccessHandler;
        if (handler == null) {
            handler = this.createDefaultSuccessHandler();
        }
        return handler;
    }

    private LogoutSuccessHandler createDefaultSuccessHandler() {
        SimpleUrlLogoutSuccessHandler urlLogoutHandler = new SimpleUrlLogoutSuccessHandler();
        urlLogoutHandler.setDefaultTargetUrl(this.logoutSuccessUrl);
        if (this.defaultLogoutSuccessHandlerMappings.isEmpty()) {
            return urlLogoutHandler;
        }
        DelegatingLogoutSuccessHandler successHandler = new DelegatingLogoutSuccessHandler(this.defaultLogoutSuccessHandlerMappings);
        successHandler.setDefaultLogoutSuccessHandler((LogoutSuccessHandler)urlLogoutHandler);
        return successHandler;
    }

    @Override
    public void init(H http) throws Exception {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter;
        if (this.permitAll) {
            PermitAllSupport.permitAll(http, new String[]{this.logoutSuccessUrl});
            PermitAllSupport.permitAll(http, new RequestMatcher[]{this.getLogoutRequestMatcher(http)});
        }
        if ((loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class)) != null && !this.isCustomLogoutSuccess()) {
            loginPageGeneratingFilter.setLogoutSuccessUrl(this.getLogoutSuccessUrl());
        }
    }

    @Override
    public void configure(H http) throws Exception {
        LogoutFilter logoutFilter = this.createLogoutFilter(http);
        http.addFilter((Filter)logoutFilter);
    }

    boolean isCustomLogoutSuccess() {
        return this.customLogoutSuccess;
    }

    private String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    List<LogoutHandler> getLogoutHandlers() {
        return this.logoutHandlers;
    }

    private LogoutFilter createLogoutFilter(H http) throws Exception {
        this.logoutHandlers.add((LogoutHandler)this.contextLogoutHandler);
        LogoutHandler[] handlers = this.logoutHandlers.toArray(new LogoutHandler[this.logoutHandlers.size()]);
        LogoutFilter result = new LogoutFilter(this.getLogoutSuccessHandler(), handlers);
        result.setLogoutRequestMatcher(this.getLogoutRequestMatcher(http));
        result = this.postProcess(result);
        return result;
    }

    private RequestMatcher getLogoutRequestMatcher(H http) {
        if (this.logoutRequestMatcher != null) {
            return this.logoutRequestMatcher;
        }
        this.logoutRequestMatcher = http.getConfigurer(CsrfConfigurer.class) != null ? new AntPathRequestMatcher(this.logoutUrl, "POST") : new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(this.logoutUrl, "GET"), new AntPathRequestMatcher(this.logoutUrl, "POST"), new AntPathRequestMatcher(this.logoutUrl, "PUT"), new AntPathRequestMatcher(this.logoutUrl, "DELETE")});
        return this.logoutRequestMatcher;
    }
}

