/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.core.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.odm.annotations.Entry;
import org.springframework.ldap.odm.annotations.Id;
import org.springframework.ldap.odm.annotations.Transient;
import org.springframework.ldap.odm.core.impl.AttributeMetaData;
import org.springframework.ldap.odm.core.impl.CaseIgnoreString;
import org.springframework.ldap.odm.core.impl.MetaDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectMetaData
implements Iterable<Field> {
    private static final Log LOG = LogFactory.getLog(ObjectMetaData.class);
    private AttributeMetaData idAttribute;
    private Map<Field, AttributeMetaData> fieldToAttribute = new HashMap<Field, AttributeMetaData>();
    private Set<CaseIgnoreString> objectClasses = new HashSet<CaseIgnoreString>();

    public Set<CaseIgnoreString> getObjectClasses() {
        return this.objectClasses;
    }

    public AttributeMetaData getIdAttribute() {
        return this.idAttribute;
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fieldToAttribute.keySet().iterator();
    }

    public AttributeMetaData getAttribute(Field field) {
        return this.fieldToAttribute.get(field);
    }

    public ObjectMetaData(Class<?> clazz) {
        Entry entity;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Extracting metadata from %1$s", clazz));
        }
        if ((entity = clazz.getAnnotation(Entry.class)) != null) {
            String[] localObjectClasses = entity.objectClasses();
            if (localObjectClasses != null && localObjectClasses.length > 0 && localObjectClasses[0].length() > 0) {
                for (String localObjectClass : localObjectClasses) {
                    this.objectClasses.add(new CaseIgnoreString(localObjectClass));
                }
            } else {
                this.objectClasses.add(new CaseIgnoreString(clazz.getSimpleName()));
            }
        } else {
            throw new MetaDataException(String.format("Class %1$s must have a class level %2$s annotation", clazz, Entry.class));
        }
        if (!Modifier.isFinal(clazz.getModifiers())) {
            LOG.warn((Object)String.format("The Entry class %1$s should be declared final", clazz.getSimpleName()));
        }
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.getAnnotation(Transient.class) != null || field.isSynthetic()) continue;
            AttributeMetaData currentAttributeMetaData = new AttributeMetaData(field);
            if (currentAttributeMetaData.isId()) {
                if (this.idAttribute != null) {
                    throw new MetaDataException(String.format("You man have only one field with the %1$s annotation in class %2$s", Id.class, clazz));
                }
                this.idAttribute = currentAttributeMetaData;
            }
            this.fieldToAttribute.put(field, currentAttributeMetaData);
        }
        if (this.idAttribute == null) {
            throw new MetaDataException(String.format("All Entry classes must define a field with the %1$s annotation, error in class %2$s", Id.class, clazz));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Extracted metadata from %1$s as %2$s", clazz, this));
        }
    }

    public String toString() {
        return String.format("objectsClasses=%1$s | idField=%2$s | attributes=%3$s", this.objectClasses, this.idAttribute.getName(), this.fieldToAttribute);
    }
}

