/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.ldif.batch;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.LdapAttributes;
import org.springframework.ldap.ldif.batch.RecordCallbackHandler;
import org.springframework.ldap.ldif.batch.RecordMapper;
import org.springframework.ldap.ldif.parser.LdifParser;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingLdifReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    private static final Log log = LogFactory.getLog(MappingLdifReader.class);
    private Resource resource;
    private LdifParser ldifParser;
    private int recordCount = 0;
    private int recordsToSkip = 0;
    private boolean strict = true;
    private RecordCallbackHandler skippedRecordsCallback;
    private RecordMapper<T> recordMapper;

    public MappingLdifReader() {
        this.setName(ClassUtils.getShortName(MappingLdifReader.class));
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSkippedRecordsCallback(RecordCallbackHandler skippedRecordsCallback) {
        this.skippedRecordsCallback = skippedRecordsCallback;
    }

    public void setRecordsToSkip(int recordsToSkip) {
        this.recordsToSkip = recordsToSkip;
    }

    public void setRecordMapper(RecordMapper<T> recordMapper) {
        this.recordMapper = recordMapper;
    }

    protected void doClose() throws Exception {
        if (this.ldifParser != null) {
            this.ldifParser.close();
        }
        this.recordCount = 0;
    }

    protected void doOpen() throws Exception {
        if (this.resource == null) {
            throw new IllegalStateException("A resource has not been set.");
        }
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode): " + this.resource);
            }
            log.warn((Object)("Input resource does not exist " + this.resource.getDescription()));
            return;
        }
        this.ldifParser.open();
        for (int i = 0; i < this.recordsToSkip; ++i) {
            LdapAttributes record = this.ldifParser.getRecord();
            if (this.skippedRecordsCallback == null) continue;
            this.skippedRecordsCallback.handleRecord(record);
        }
    }

    protected T doRead() throws Exception {
        LdapAttributes attributes = null;
        try {
            if (this.ldifParser != null) {
                while (attributes == null && this.ldifParser.hasMoreRecords()) {
                    attributes = this.ldifParser.getRecord();
                }
                ++this.recordCount;
                return this.recordMapper.mapRecord(attributes);
            }
            return null;
        }
        catch (Exception ex) {
            log.error((Object)("Parsing error at record " + this.recordCount + " in resource=" + this.resource.getDescription() + ", input=[" + attributes + "]"), (Throwable)ex);
            throw ex;
        }
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        this.ldifParser = new LdifParser(resource);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resource, (String)"A resource is required to parse.");
        Assert.notNull((Object)this.ldifParser);
    }
}

