/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.hateoas.MethodLinkBuilderFactory;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.core.DummyInvocationUtils;
import org.springframework.hateoas.core.EncodingUtils;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.hateoas.mvc.AnnotatedParametersParameterAccessor;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.Java8Utils;
import org.springframework.hateoas.mvc.UriComponentsContributor;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class ControllerLinkBuilderFactory
implements MethodLinkBuilderFactory<ControllerLinkBuilder> {
    private static final MappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(RequestMapping.class);
    private static final AnnotatedParametersParameterAccessor PATH_VARIABLE_ACCESSOR = new AnnotatedParametersParameterAccessor(new AnnotationAttribute(PathVariable.class));
    private static final AnnotatedParametersParameterAccessor REQUEST_PARAM_ACCESSOR = new RequestParamParameterAccessor();
    private List<UriComponentsContributor> uriComponentsContributors = new ArrayList<UriComponentsContributor>();

    public void setUriComponentsContributors(List<? extends UriComponentsContributor> uriComponentsContributors) {
        this.uriComponentsContributors = Collections.unmodifiableList(uriComponentsContributors);
    }

    @Override
    public ControllerLinkBuilder linkTo(Class<?> controller) {
        return ControllerLinkBuilder.linkTo(controller);
    }

    @Override
    public ControllerLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        return ControllerLinkBuilder.linkTo(controller, parameters);
    }

    @Override
    public ControllerLinkBuilder linkTo(Class<?> controller, Map<String, ?> parameters) {
        return ControllerLinkBuilder.linkTo(controller, parameters);
    }

    @Override
    public ControllerLinkBuilder linkTo(Class<?> controller, Method method, Object ... parameters) {
        return ControllerLinkBuilder.linkTo(controller, method, parameters);
    }

    @Override
    public ControllerLinkBuilder linkTo(Object invocationValue) {
        Assert.isInstanceOf(DummyInvocationUtils.LastInvocationAware.class, (Object)invocationValue);
        DummyInvocationUtils.LastInvocationAware invocations = (DummyInvocationUtils.LastInvocationAware)invocationValue;
        DummyInvocationUtils.MethodInvocation invocation = invocations.getLastInvocation();
        Iterator<Object> classMappingParameters = invocations.getObjectParameters();
        Method method = invocation.getMethod();
        String mapping = DISCOVERER.getMapping(invocation.getTargetType(), method);
        UriComponentsBuilder builder = ControllerLinkBuilder.getBuilder().path(mapping);
        UriTemplate template = new UriTemplate(mapping);
        HashMap<Object, Object> values = new HashMap<Object, Object>();
        Iterator names = template.getVariableNames().iterator();
        while (classMappingParameters.hasNext()) {
            values.put(names.next(), EncodingUtils.encodePath(classMappingParameters.next()));
        }
        for (AnnotatedParametersParameterAccessor.BoundMethodParameter boundMethodParameter : PATH_VARIABLE_ACCESSOR.getBoundParameters(invocation)) {
            values.put(boundMethodParameter.getVariableName(), EncodingUtils.encodePath(boundMethodParameter.asString()));
        }
        ArrayList<String> optionalEmptyParameters = new ArrayList<String>();
        for (AnnotatedParametersParameterAccessor.BoundMethodParameter parameter : REQUEST_PARAM_ACCESSOR.getBoundParameters(invocation)) {
            ControllerLinkBuilderFactory.bindRequestParameters(builder, parameter);
            if (!UriComponents.UriTemplateVariables.SKIP_VALUE.equals(parameter.getValue())) continue;
            values.put(parameter.getVariableName(), UriComponents.UriTemplateVariables.SKIP_VALUE);
            if (parameter.isRequired()) continue;
            optionalEmptyParameters.add(parameter.getVariableName());
        }
        for (String variable : template.getVariableNames()) {
            if (values.containsKey(variable)) continue;
            values.put(variable, UriComponents.UriTemplateVariables.SKIP_VALUE);
        }
        UriComponents uriComponents = this.applyUriComponentsContributer(builder, invocation).buildAndExpand(values);
        TemplateVariables variables = TemplateVariables.NONE;
        for (String parameter : optionalEmptyParameters) {
            boolean previousRequestParameter = uriComponents.getQueryParams().isEmpty() && variables.equals(TemplateVariables.NONE);
            TemplateVariable variable = new TemplateVariable(parameter, previousRequestParameter ? TemplateVariable.VariableType.REQUEST_PARAM : TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED);
            variables = variables.concat(variable);
        }
        return new ControllerLinkBuilder(uriComponents, variables);
    }

    @Override
    public ControllerLinkBuilder linkTo(Method method, Object ... parameters) {
        return ControllerLinkBuilder.linkTo(method, parameters);
    }

    protected UriComponentsBuilder applyUriComponentsContributer(UriComponentsBuilder builder, DummyInvocationUtils.MethodInvocation invocation) {
        MethodParameters parameters = new MethodParameters(invocation.getMethod());
        Iterator<Object> parameterValues = Arrays.asList(invocation.getArguments()).iterator();
        for (MethodParameter parameter : parameters.getParameters()) {
            Object parameterValue = parameterValues.next();
            for (UriComponentsContributor contributor : this.uriComponentsContributors) {
                if (!contributor.supportsParameter(parameter)) continue;
                contributor.enhance(builder, parameter, parameterValue);
            }
        }
        return builder;
    }

    private static void bindRequestParameters(UriComponentsBuilder builder, AnnotatedParametersParameterAccessor.BoundMethodParameter parameter) {
        Object value = parameter.getValue();
        String key = parameter.getVariableName();
        if (value instanceof MultiValueMap) {
            MultiValueMap requestParams = (MultiValueMap)value;
            for (Map.Entry multiValueEntry : requestParams.entrySet()) {
                for (String singleEntryValue : (List)multiValueEntry.getValue()) {
                    builder.queryParam((String)multiValueEntry.getKey(), new Object[]{EncodingUtils.encodeParameter(singleEntryValue)});
                }
            }
        } else if (value instanceof Map) {
            Map requestParams = (Map)value;
            for (Map.Entry requestParamEntry : requestParams.entrySet()) {
                builder.queryParam((String)requestParamEntry.getKey(), new Object[]{EncodingUtils.encodeParameter(requestParamEntry.getValue())});
            }
        } else if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                builder.queryParam(key, new Object[]{EncodingUtils.encodeParameter(element)});
            }
        } else if (UriComponents.UriTemplateVariables.SKIP_VALUE.equals(value)) {
            if (parameter.isRequired()) {
                builder.queryParam(key, new Object[]{String.format("{%s}", parameter.getVariableName())});
            }
        } else {
            builder.queryParam(key, new Object[]{EncodingUtils.encodeParameter(parameter.asString())});
        }
    }

    private static class RequestParamParameterAccessor
    extends AnnotatedParametersParameterAccessor {
        public RequestParamParameterAccessor() {
            super(new AnnotationAttribute(RequestParam.class));
        }

        @Override
        protected AnnotatedParametersParameterAccessor.BoundMethodParameter createParameter(final MethodParameter parameter, Object value, AnnotationAttribute attribute) {
            return new AnnotatedParametersParameterAccessor.BoundMethodParameter(parameter, value, attribute){

                @Override
                public boolean isRequired() {
                    RequestParam annotation = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
                    if (Java8Utils.isJava8Optional(parameter.getParameterType())) {
                        return false;
                    }
                    return annotation.required() && annotation.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
                }
            };
        }

        @Override
        protected Object verifyParameterValue(MethodParameter parameter, Object value) {
            RequestParam annotation = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
            if ((value = Java8Utils.unwrapJava8Optional(value)) != null) {
                return value;
            }
            if (!annotation.required() || Java8Utils.isJava8Optional(parameter.getParameterType())) {
                return UriComponents.UriTemplateVariables.SKIP_VALUE;
            }
            return annotation.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") ? UriComponents.UriTemplateVariables.SKIP_VALUE : null;
        }
    }
}

