/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.jaxrs;

import java.util.Map;
import javax.ws.rs.Path;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.core.LinkBuilderSupport;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class JaxRsLinkBuilder
extends LinkBuilderSupport<JaxRsLinkBuilder> {
    private static final MappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(Path.class);
    private static final CustomUriTemplateHandler HANDLER = new CustomUriTemplateHandler();

    private JaxRsLinkBuilder(UriComponentsBuilder builder) {
        super(builder);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> service) {
        return JaxRsLinkBuilder.linkTo(service, new Object[0]);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> resourceType, Object ... parameters) {
        Assert.notNull(resourceType, (String)"Controller type must not be null!");
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)DISCOVERER.getMapping(resourceType));
        UriComponents expandedComponents = HANDLER.expandAndEncode(builder, parameters);
        return (JaxRsLinkBuilder)new JaxRsLinkBuilder((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentServletMapping()).slash(expandedComponents, true);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> resourceType, Map<String, ?> parameters) {
        Assert.notNull(resourceType, (String)"Controller type must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)DISCOVERER.getMapping(resourceType));
        UriComponents expandedComponents = HANDLER.expandAndEncode(builder, parameters);
        return (JaxRsLinkBuilder)new JaxRsLinkBuilder((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentServletMapping()).slash(expandedComponents, true);
    }

    @Override
    protected JaxRsLinkBuilder getThis() {
        return this;
    }

    @Override
    protected JaxRsLinkBuilder createNewInstance(UriComponentsBuilder builder) {
        return new JaxRsLinkBuilder(builder);
    }

    private static class CustomUriTemplateHandler
    extends DefaultUriTemplateHandler {
        public CustomUriTemplateHandler() {
            this.setStrictEncoding(true);
        }

        public UriComponents expandAndEncode(UriComponentsBuilder builder, Map<String, ?> uriVariables) {
            return super.expandAndEncode(builder, uriVariables);
        }

        public UriComponents expandAndEncode(UriComponentsBuilder builder, Object[] uriVariables) {
            return super.expandAndEncode(builder, uriVariables);
        }
    }
}

