/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;

@XmlRootElement(name="entities")
public class Resources<T>
extends ResourceSupport
implements Iterable<T> {
    private final Collection<T> content;

    protected Resources() {
        this(new ArrayList(), new Link[0]);
    }

    public Resources(Iterable<T> content, Link ... links) {
        this(content, Arrays.asList(links));
    }

    public Resources(Iterable<T> content, Iterable<Link> links) {
        Assert.notNull(content, (String)"Content must not be null!");
        this.content = new ArrayList<T>();
        for (T element : content) {
            this.content.add(element);
        }
        this.add(links);
    }

    public static <T extends Resource<S>, S> Resources<T> wrap(Iterable<S> content) {
        Assert.notNull(content, (String)"Content must not be null!");
        ArrayList<Resource<S>> resources = new ArrayList<Resource<S>>();
        for (S element : content) {
            resources.add(new Resource<S>(element, new Link[0]));
        }
        return new Resources(resources, new Link[0]);
    }

    @XmlAnyElement
    @XmlElementWrapper
    @JsonProperty(value="content")
    public Collection<T> getContent() {
        return Collections.unmodifiableCollection(this.content);
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public String toString() {
        return String.format("Resources { content: %s, %s }", this.getContent(), super.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Resources that = (Resources)obj;
        boolean contentEqual = this.content == null ? that.content == null : this.content.equals(that.content);
        return contentEqual ? super.equals(obj) : false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.content == null ? 0 : 17 * this.content.hashCode();
    }
}

