/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.MongoParsingUtils;
import org.springframework.data.mongodb.core.MongoFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        String id = element.getAttribute("id");
        BeanComponentDefinitionBuilder helper = new BeanComponentDefinitionBuilder(element, parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MongoFactoryBean.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)builder, (Element)element, (String)"port", (String)"port");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)builder, (Element)element, (String)"host", (String)"host");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)builder, (Element)element, (String)"write-concern", (String)"writeConcern");
        MongoParsingUtils.parseMongoOptions(element, builder);
        MongoParsingUtils.parseReplicaSet(element, builder);
        String defaultedId = StringUtils.hasText((String)id) ? id : "mongo";
        parserContext.pushContainingComponent(new CompositeComponentDefinition("Mongo", source));
        BeanComponentDefinition mongoComponent = helper.getComponent(builder, defaultedId);
        parserContext.registerBeanComponent(mongoComponent);
        BeanComponentDefinition serverAddressPropertyEditor = helper.getComponent(this.registerServerAddressPropertyEditor());
        parserContext.registerBeanComponent(serverAddressPropertyEditor);
        BeanComponentDefinition writeConcernPropertyEditor = helper.getComponent(MongoParsingUtils.getWriteConcernPropertyEditorBuilder());
        parserContext.registerBeanComponent(writeConcernPropertyEditor);
        parserContext.popAndRegisterContainingComponent();
        return mongoComponent.getBeanDefinition();
    }

    private BeanDefinitionBuilder registerServerAddressPropertyEditor() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.ServerAddress[]", "org.springframework.data.mongodb.config.ServerAddressPropertyEditor");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }
}

