/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.SpelExpressionTransformer;
import org.springframework.util.Assert;

public abstract class BucketOperationSupport<T extends BucketOperationSupport<T, B>, B extends OutputBuilder<B, T>>
implements FieldsExposingAggregationOperation {
    private final Field groupByField;
    private final AggregationExpression groupByExpression;
    private final Outputs outputs;

    protected BucketOperationSupport(Field groupByField) {
        Assert.notNull((Object)groupByField, (String)"Group by field must not be null!");
        this.groupByField = groupByField;
        this.groupByExpression = null;
        this.outputs = Outputs.EMPTY;
    }

    protected BucketOperationSupport(AggregationExpression groupByExpression) {
        Assert.notNull((Object)groupByExpression, (String)"Group by AggregationExpression must not be null!");
        this.groupByExpression = groupByExpression;
        this.groupByField = null;
        this.outputs = Outputs.EMPTY;
    }

    protected BucketOperationSupport(BucketOperationSupport<?, ?> operationSupport) {
        this(operationSupport, operationSupport.outputs);
    }

    protected BucketOperationSupport(BucketOperationSupport<?, ?> operationSupport, Outputs outputs) {
        Assert.notNull(operationSupport, (String)"BucketOperationSupport must not be null!");
        Assert.notNull((Object)outputs, (String)"Outputs must not be null!");
        this.groupByField = operationSupport.groupByField;
        this.groupByExpression = operationSupport.groupByExpression;
        this.outputs = outputs;
    }

    public abstract ExpressionBucketOperationBuilderSupport<B, T> andOutputExpression(String var1, Object ... var2);

    public abstract B andOutput(AggregationExpression var1);

    public abstract B andOutput(String var1);

    public B andOutputCount() {
        return this.andOutput(new AggregationExpression(){

            @Override
            public DBObject toDbObject(AggregationOperationContext context) {
                return new BasicDBObject("$sum", (Object)1);
            }
        });
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        BasicDBObject dbObject = new BasicDBObject();
        dbObject.put("groupBy", (Object)(this.groupByExpression == null ? context.getReference(this.groupByField).toString() : this.groupByExpression.toDbObject(context)));
        if (!this.outputs.isEmpty()) {
            dbObject.put("output", (Object)this.outputs.toDbObject(context));
        }
        return dbObject;
    }

    @Override
    public ExposedFields getFields() {
        return this.outputs.asExposedFields();
    }

    protected abstract T newBucketOperation(Outputs var1);

    protected T andOutput(Output output) {
        return this.newBucketOperation(this.outputs.and(output));
    }

    private static class AggregationExpressionOutput
    extends Output {
        private final AggregationExpression expression;

        protected AggregationExpressionOutput(Field field, AggregationExpression expression) {
            super(field);
            this.expression = expression;
        }

        @Override
        public DBObject toDbObject(AggregationOperationContext context) {
            return this.expression.toDbObject(context);
        }
    }

    private static class SpelExpressionOutput
    extends Output {
        private static final SpelExpressionTransformer TRANSFORMER = new SpelExpressionTransformer();
        private final String expression;
        private final Object[] params;

        public SpelExpressionOutput(String expression, Object[] parameters) {
            super(Fields.field(expression));
            Assert.hasText((String)expression, (String)"Expression must not be null!");
            Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
            this.expression = expression;
            this.params = (Object[])parameters.clone();
        }

        @Override
        public DBObject toDbObject(AggregationOperationContext context) {
            return (DBObject)TRANSFORMER.transform(this.expression, context, this.params);
        }
    }

    protected static class OperationOutput
    extends Output {
        private final String operation;
        private final List<Object> values;

        public OperationOutput(String operation, Collection<? extends Object> values) {
            super(Fields.field(operation));
            Assert.hasText((String)operation, (String)"Operation must not be null or empty!");
            Assert.notNull(values, (String)"Values must not be null!");
            this.operation = operation;
            this.values = new ArrayList<Object>(values);
        }

        private OperationOutput(Field field, OperationOutput operationOutput) {
            super(field);
            this.operation = operationOutput.operation;
            this.values = operationOutput.values;
        }

        @Override
        public DBObject toDbObject(AggregationOperationContext context) {
            List<Object> operationArguments = this.getOperationArguments(context);
            return new BasicDBObject(this.operation, operationArguments.size() == 1 ? operationArguments.get(0) : operationArguments);
        }

        protected List<Object> getOperationArguments(AggregationOperationContext context) {
            ArrayList<Object> result = new ArrayList<Object>(this.values != null ? this.values.size() : 1);
            for (Object element : this.values) {
                if (element instanceof Field) {
                    result.add(context.getReference((Field)element).toString());
                    continue;
                }
                if (element instanceof Fields) {
                    for (Field field : (Fields)element) {
                        result.add(context.getReference(field).toString());
                    }
                    continue;
                }
                if (element instanceof AggregationExpression) {
                    result.add(((AggregationExpression)element).toDbObject(context));
                    continue;
                }
                result.add(element);
            }
            return result;
        }

        protected Field getField() {
            return this.getExposedField();
        }

        public OperationOutput withAlias(String alias) {
            final Field aliasedField = Fields.field(alias);
            return new OperationOutput(aliasedField, this){

                @Override
                protected Field getField() {
                    return aliasedField;
                }

                @Override
                protected List<Object> getOperationArguments(AggregationOperationContext context) {
                    return OperationOutput.this.getOperationArguments(context);
                }
            };
        }
    }

    protected static abstract class Output
    implements AggregationExpression {
        private final ExposedFields.ExposedField field;

        protected Output(Field field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            this.field = new ExposedFields.ExposedField(field, true);
        }

        protected ExposedFields.ExposedField getExposedField() {
            return this.field;
        }
    }

    protected static class Outputs
    implements AggregationExpression {
        protected static final Outputs EMPTY = new Outputs();
        private List<Output> outputs;

        private Outputs() {
            this.outputs = new ArrayList<Output>();
        }

        private Outputs(Collection<Output> current, Output output) {
            this.outputs = new ArrayList<Output>(current.size() + 1);
            this.outputs.addAll(current);
            this.outputs.add(output);
        }

        protected ExposedFields asExposedFields() {
            if (this.isEmpty()) {
                return ExposedFields.from(new ExposedFields.ExposedField("count", true));
            }
            ExposedFields fields = ExposedFields.from(new ExposedFields.ExposedField[0]);
            for (Output output : this.outputs) {
                fields = fields.and(output.getExposedField());
            }
            return fields;
        }

        protected Outputs and(Output output) {
            Assert.notNull((Object)output, (String)"BucketOutput must not be null!");
            return new Outputs(this.outputs, output);
        }

        protected boolean isEmpty() {
            return this.outputs.isEmpty();
        }

        @Override
        public DBObject toDbObject(AggregationOperationContext context) {
            BasicDBObject dbObject = new BasicDBObject();
            for (Output output : this.outputs) {
                dbObject.put(output.getExposedField().getName(), (Object)output.toDbObject(context));
            }
            return dbObject;
        }
    }

    private static enum Accumulators {
        SUM("$sum"),
        AVG("$avg"),
        FIRST("$first"),
        LAST("$last"),
        MAX("$max"),
        MIN("$min"),
        PUSH("$push"),
        ADDTOSET("$addToSet");

        private String mongoOperator;

        private Accumulators(String mongoOperator) {
            this.mongoOperator = mongoOperator;
        }

        public String getMongoOperator() {
            return this.mongoOperator;
        }
    }

    public static abstract class OutputBuilder<B extends OutputBuilder<B, T>, T extends BucketOperationSupport<T, B>> {
        protected final Object value;
        protected final T operation;

        protected OutputBuilder(Object value, T operation) {
            Assert.notNull((Object)value, (String)"Value must not be null or empty!");
            Assert.notNull(operation, (String)"ProjectionOperation must not be null!");
            this.value = value;
            this.operation = operation;
        }

        public B count() {
            return this.sum(1);
        }

        public B sum() {
            return this.apply(Accumulators.SUM);
        }

        public B sum(Number value) {
            return this.apply(new OperationOutput(Accumulators.SUM.getMongoOperator(), Collections.singleton(value)));
        }

        public B last() {
            return this.apply(Accumulators.LAST);
        }

        public B first() {
            return this.apply(Accumulators.FIRST);
        }

        public B avg() {
            return this.apply(Accumulators.AVG);
        }

        public B min() {
            return this.apply(Accumulators.MIN);
        }

        public B max() {
            return this.apply(Accumulators.MAX);
        }

        public B push() {
            return this.apply(Accumulators.PUSH);
        }

        public B addToSet() {
            return this.apply(Accumulators.ADDTOSET);
        }

        public B apply(String operation, Object ... values) {
            Assert.hasText((String)operation, (String)"Operation must not be empty or null!");
            Assert.notNull((Object)this.value, (String)"Values must not be null!");
            ArrayList<Object> objects = new ArrayList<Object>(values.length + 1);
            objects.add(this.value);
            objects.addAll(Arrays.asList(values));
            return this.apply(new OperationOutput(operation, objects));
        }

        protected abstract B apply(OperationOutput var1);

        private B apply(Accumulators operation) {
            return this.apply(operation.getMongoOperator(), new Object[0]);
        }

        public T as(String alias) {
            if (this.value instanceof OperationOutput) {
                return ((BucketOperationSupport)this.operation).andOutput(((OperationOutput)this.value).withAlias(alias));
            }
            if (this.value instanceof Field) {
                throw new IllegalStateException("Cannot add a field as top-level output. Use accumulator expressions.");
            }
            return ((BucketOperationSupport)this.operation).andOutput(new AggregationExpressionOutput(Fields.field(alias), (AggregationExpression)this.value));
        }
    }

    public static abstract class ExpressionBucketOperationBuilderSupport<B extends OutputBuilder<B, T>, T extends BucketOperationSupport<T, B>>
    extends OutputBuilder<B, T> {
        protected ExpressionBucketOperationBuilderSupport(String expression, T operation, Object[] parameters) {
            super(new SpelExpressionOutput(expression, parameters), operation);
        }
    }
}

