/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.geo.Shape;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Circle
implements Shape {
    private final Point center;
    private final double radius;

    @PersistenceConstructor
    public Circle(Point center, double radius) {
        Assert.notNull((Object)center);
        Assert.isTrue((radius >= 0.0 ? 1 : 0) != 0, (String)"Radius must not be negative!");
        this.center = center;
        this.radius = radius;
    }

    public Circle(double centerX, double centerY, double radius) {
        this(new Point(centerX, centerY), radius);
    }

    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public List<Object> asList() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.getCenter().asList());
        result.add(this.getRadius());
        return result;
    }

    @Override
    public String getCommand() {
        return "$center";
    }

    public String toString() {
        return String.format("Circle [center=%s, radius=%f]", this.center, this.radius);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Circle that = (Circle)obj;
        return this.center.equals(that.center) && this.radius == that.radius;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.center.hashCode();
        result = (int)((double)result + 31.0 * this.radius);
        return result;
    }
}

