/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.ServerAddress;
import java.beans.PropertyEditorSupport;
import java.net.UnknownHostException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class ServerAddressPropertyEditor
extends PropertyEditorSupport {
    private static final Log LOG = LogFactory.getLog(ServerAddressPropertyEditor.class);

    public void setAsText(String replicaSetString) {
        String[] replicaSetStringArray = StringUtils.commaDelimitedListToStringArray((String)replicaSetString);
        HashSet<ServerAddress> serverAddresses = new HashSet<ServerAddress>(replicaSetStringArray.length);
        for (String element : replicaSetStringArray) {
            ServerAddress address = this.parseServerAddress(element);
            if (address == null) continue;
            serverAddresses.add(address);
        }
        if (serverAddresses.isEmpty()) {
            throw new IllegalArgumentException("Could not resolve at least one server of the replica set configuration! Validate your config!");
        }
        this.setValue(serverAddresses.toArray(new ServerAddress[serverAddresses.size()]));
    }

    private ServerAddress parseServerAddress(String source) {
        String[] hostAndPort = StringUtils.delimitedListToStringArray((String)source.trim(), (String)":");
        if (!StringUtils.hasText((String)source) || hostAndPort.length > 2) {
            LOG.warn((Object)String.format("Could not parse address source '%s'. Check your replica set configuration!", source));
            return null;
        }
        try {
            return hostAndPort.length == 1 ? new ServerAddress(hostAndPort[0]) : new ServerAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)String.format("Could not parse host '%s'. Check your replica set configuration!", hostAndPort[0]));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)String.format("Could not parse port '%s'. Check your replica set configuration!", hostAndPort[1]));
        }
        return null;
    }
}

