/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.LockModeType;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.support.LockMetadataProvider;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public enum LockModeRepositoryPostProcessor implements RepositoryProxyPostProcessor
{
    INSTANCE;

    private static final Object NULL;

    public void postProcess(ProxyFactory factory) {
        factory.addAdvice((Advice)ExposeInvocationInterceptor.INSTANCE);
        factory.addAdvice((Advice)LockModePopulatingMethodIntercceptor.INSTANCE);
    }

    public LockMetadataProvider getLockMetadataProvider() {
        return ThreadBoundLockMetadata.INSTANCE;
    }

    static {
        NULL = new Object();
    }

    private static enum ThreadBoundLockMetadata implements LockMetadataProvider
    {
        INSTANCE;


        @Override
        public LockModeType getLockModeType() {
            MethodInvocation invocation = ExposeInvocationInterceptor.currentInvocation();
            Object lockModeType = TransactionSynchronizationManager.getResource((Object)invocation.getMethod());
            return lockModeType == NULL ? null : (LockModeType)lockModeType;
        }
    }

    static enum LockModePopulatingMethodIntercceptor implements MethodInterceptor
    {
        INSTANCE;

        private final Map<Method, Object> lockModeTypeCache = new HashMap<Method, Object>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object lockInfo = TransactionSynchronizationManager.getResource((Object)method);
            if (lockInfo != null) {
                return invocation.proceed();
            }
            Object lockModeType = this.lockModeTypeCache.get(method);
            if (lockModeType == null) {
                Lock annotation = (Lock)AnnotationUtils.findAnnotation((Method)method, Lock.class);
                lockModeType = AnnotationUtils.getValue((Annotation)annotation);
                lockModeType = lockModeType == null ? NULL : lockModeType;
                this.lockModeTypeCache.put(method, lockModeType);
            }
            TransactionSynchronizationManager.bindResource((Object)method, (Object)lockModeType);
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                TransactionSynchronizationManager.unbindResource((Object)method);
            }
        }
    }
}

