/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.data.util.LazyStreamable;
import org.springframework.util.Assert;

@FunctionalInterface
public interface Streamable<T>
extends Iterable<T> {
    public static <T> Streamable<T> empty() {
        return Collections::emptyIterator;
    }

    @SafeVarargs
    public static <T> Streamable<T> of(T ... t) {
        return () -> Arrays.asList(t).iterator();
    }

    public static <T> Streamable<T> of(Iterable<T> iterable) {
        Assert.notNull(iterable, (String)"Iterable must not be null!");
        return iterable::iterator;
    }

    public static <T> Streamable<T> of(Supplier<? extends Stream<T>> supplier) {
        return LazyStreamable.of(supplier);
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public <R> Streamable<R> map(Function<? super T, ? extends R> mapper) {
        Assert.notNull(mapper, (String)"Mapping function must not be null!");
        return Streamable.of(() -> this.stream().map(mapper));
    }

    default public <R> Streamable<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        Assert.notNull(mapper, (String)"Mapping function must not be null!");
        return Streamable.of(() -> this.stream().flatMap(mapper));
    }

    default public Streamable<T> filter(Predicate<? super T> predicate) {
        Assert.notNull(predicate, (String)"Filter predicate must not be null!");
        return Streamable.of(() -> this.stream().filter(predicate));
    }
}

