/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

class AnnotationAttribute {
    @NonNull
    private final Class<? extends Annotation> annotationType;
    @NonNull
    private final Optional<String> attributeName;

    public AnnotationAttribute(Class<? extends Annotation> annotationType) {
        this(annotationType, Optional.empty());
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public Optional<Object> getValueFrom(MethodParameter parameter) {
        Assert.notNull((Object)parameter, (String)"MethodParameter must not be null!");
        Annotation annotation = parameter.getParameterAnnotation(this.annotationType);
        return Optional.ofNullable(annotation).map(this::getValueFrom);
    }

    public Optional<Object> getValueFrom(AnnotatedElement annotatedElement) {
        Assert.notNull((Object)annotatedElement, (String)"Annotated element must not be null!");
        Annotation annotation = annotatedElement.getAnnotation(this.annotationType);
        return Optional.ofNullable(annotation).map(it -> this.getValueFrom(annotation));
    }

    public Object getValueFrom(Annotation annotation) {
        Assert.notNull((Object)annotation, (String)"Annotation must not be null!");
        return this.attributeName.map(it -> AnnotationUtils.getValue((Annotation)annotation, (String)it)).orElseGet(() -> AnnotationUtils.getValue((Annotation)annotation));
    }

    @ConstructorProperties(value={"annotationType", "attributeName"})
    public AnnotationAttribute(@NonNull Class<? extends Annotation> annotationType, @NonNull Optional<String> attributeName) {
        if (annotationType == null) {
            throw new IllegalArgumentException("annotationType is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        this.annotationType = annotationType;
        this.attributeName = attributeName;
    }
}

