/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.init;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.init.RepositoriesPopulatedEvent;
import org.springframework.data.repository.init.RepositoryPopulator;
import org.springframework.data.repository.init.ResourceReader;
import org.springframework.data.repository.support.Repositories;
import org.springframework.util.Assert;

public class ResourceReaderRepositoryPopulator
implements RepositoryPopulator,
ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceReaderRepositoryPopulator.class);
    private final ResourcePatternResolver resolver;
    private final ResourceReader reader;
    private final ClassLoader classLoader;
    private ApplicationEventPublisher publisher;
    private Collection<Resource> resources;

    public ResourceReaderRepositoryPopulator(ResourceReader reader) {
        this(reader, null);
    }

    public ResourceReaderRepositoryPopulator(ResourceReader reader, ClassLoader classLoader) {
        Assert.notNull((Object)reader);
        this.reader = reader;
        this.classLoader = classLoader;
        this.resolver = classLoader == null ? new PathMatchingResourcePatternResolver() : new PathMatchingResourcePatternResolver(classLoader);
    }

    public void setResourceLocation(String location) throws IOException {
        Assert.hasText((String)location);
        this.setResources(this.resolver.getResources(location));
    }

    public void setResources(Resource ... resources) {
        this.resources = Arrays.asList(resources);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void populate(Repositories repositories) {
        for (Resource resource : this.resources) {
            LOGGER.info(String.format("Reading resource: %s", resource));
            Object result = this.readObjectFrom(resource);
            if (result instanceof Collection) {
                for (Object element : (Collection)result) {
                    if (element != null) {
                        this.persist(element, repositories);
                        continue;
                    }
                    LOGGER.info("Skipping null element found in unmarshal result!");
                }
                continue;
            }
            this.persist(result, repositories);
        }
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)new RepositoriesPopulatedEvent(this, repositories));
        }
    }

    private Object readObjectFrom(Resource resource) {
        try {
            return this.reader.readFrom(resource, this.classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void persist(Object object, Repositories repositories) {
        CrudRepository repository = repositories.getRepositoryFor(object.getClass());
        LOGGER.debug(String.format("Persisting %s using repository %s", object, repository));
        repository.save(object);
    }
}

