/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.AbstractList;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;

class LazyWeightedServiceInstanceList
extends AbstractList<ServiceInstance> {
    private final List<ServiceInstance> instances;
    private final int[] weights;
    private SmoothServiceInstanceSelector selector;
    private volatile int position;
    ServiceInstance[] expanded;
    private final Object expandingLock = new Object();

    LazyWeightedServiceInstanceList(List<ServiceInstance> instances, int[] weights) {
        this.instances = instances;
        this.weights = weights;
        this.init();
    }

    private void init() {
        int greatestCommonDivisor = 0;
        int max = 0;
        int total = 0;
        for (int weight : this.weights) {
            greatestCommonDivisor = LazyWeightedServiceInstanceList.greatestCommonDivisor(greatestCommonDivisor, weight);
            max = Math.max(max, weight);
            total += weight;
        }
        this.selector = new SmoothServiceInstanceSelector(this.instances, this.weights, max, greatestCommonDivisor);
        this.position = 0;
        this.expanded = new ServiceInstance[total / greatestCommonDivisor];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInstance get(int index) {
        if (index < this.position) {
            return this.expanded[index];
        }
        Object object = this.expandingLock;
        synchronized (object) {
            while (this.position <= index && this.position < this.expanded.length) {
                this.expanded[this.position] = this.selector.next();
                ++this.position;
            }
        }
        return this.expanded[index];
    }

    @Override
    public int size() {
        return this.expanded.length;
    }

    static int greatestCommonDivisor(int a, int b) {
        while (b != 0) {
            int r = a % b;
            a = b;
            b = r;
        }
        return a;
    }

    static class SmoothServiceInstanceSelector {
        final List<ServiceInstance> instances;
        final int[] weights;
        final int maxWeight;
        final int gcd;
        int position;
        int currentWeight;

        SmoothServiceInstanceSelector(List<ServiceInstance> instances, int[] weights, int maxWeight, int gcd) {
            this.instances = instances;
            this.weights = weights;
            this.maxWeight = maxWeight;
            this.gcd = gcd;
            this.currentWeight = 0;
        }

        /*
         * Unable to fully structure code
         */
        ServiceInstance next() {
            while (true) {
                for (picked = this.position; picked < this.weights.length; ++picked) {
                    if (this.weights[picked] <= this.currentWeight) continue;
                    this.position = picked + 1;
                    return this.instances.get(picked);
                }
                this.position = 0;
                this.currentWeight += this.gcd;
                if (this.currentWeight < this.maxWeight) ** continue;
                this.currentWeight = 0;
            }
        }
    }
}

