/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheProperties;
import org.springframework.cloud.loadbalancer.core.CachingServiceInstanceListSupplier;
import org.springframework.util.StringUtils;

public class CaffeineBasedLoadBalancerCacheManager
extends CaffeineCacheManager
implements LoadBalancerCacheManager {
    public CaffeineBasedLoadBalancerCacheManager(String cacheName, LoadBalancerCacheProperties properties) {
        super(new String[]{cacheName});
        if (StringUtils.hasText((String)properties.getCaffeine().getSpec())) {
            this.setCacheSpecification(properties.getCaffeine().getSpec());
        } else {
            this.setCaffeine(Caffeine.newBuilder().initialCapacity(properties.getCapacity()).expireAfterWrite(properties.getTtl()).softValues());
        }
    }

    public CaffeineBasedLoadBalancerCacheManager(LoadBalancerCacheProperties properties) {
        this(CachingServiceInstanceListSupplier.SERVICE_INSTANCE_CACHE_NAME, properties);
    }
}

