/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.boot.web.client.RootUriTemplateHandler;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.NoOpResponseErrorHandler;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

public class TestRestTemplate {
    private final RestTemplateBuilder builder;
    private final HttpClientOption[] httpClientOptions;
    private final RestTemplate restTemplate;

    public TestRestTemplate(RestTemplateBuilder restTemplateBuilder) {
        this(restTemplateBuilder, null, null, new HttpClientOption[0]);
    }

    public TestRestTemplate(HttpClientOption ... httpClientOptions) {
        this((String)null, (String)null, httpClientOptions);
    }

    public TestRestTemplate(String username, String password, HttpClientOption ... httpClientOptions) {
        this(new RestTemplateBuilder(new RestTemplateCustomizer[0]), username, password, httpClientOptions);
    }

    public TestRestTemplate(RestTemplateBuilder builder, String username, String password, HttpClientOption ... httpClientOptions) {
        ClientHttpRequestFactory requestFactory;
        Assert.notNull((Object)builder, (String)"Builder must not be null");
        this.builder = builder;
        this.httpClientOptions = httpClientOptions;
        if (httpClientOptions != null && (requestFactory = builder.buildRequestFactory()) instanceof HttpComponentsClientHttpRequestFactory) {
            builder = builder.requestFactoryBuilder(settings -> new CustomHttpComponentsClientHttpRequestFactory(httpClientOptions, settings));
        }
        if (username != null || password != null) {
            builder = builder.basicAuthentication(username, password);
        }
        this.restTemplate = builder.build();
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
    }

    public void setUriTemplateHandler(UriTemplateHandler handler) {
        this.restTemplate.setUriTemplateHandler(handler);
    }

    public String getRootUri() {
        UriTemplateHandler uriTemplateHandler = this.restTemplate.getUriTemplateHandler();
        if (uriTemplateHandler instanceof RootUriTemplateHandler) {
            RootUriTemplateHandler rootHandler = (RootUriTemplateHandler)uriTemplateHandler;
            return rootHandler.getRootUri();
        }
        return "";
    }

    public <T> T getForObject(String url, Class<T> responseType, Object ... urlVariables) {
        return (T)this.restTemplate.getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(String url, Class<T> responseType, Map<String, ?> urlVariables) {
        return (T)this.restTemplate.getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(URI url, Class<T> responseType) {
        return (T)this.restTemplate.getForObject(this.applyRootUriIfNecessary(url), responseType);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Object ... urlVariables) {
        return this.restTemplate.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> urlVariables) {
        return this.restTemplate.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(URI url, Class<T> responseType) {
        return this.restTemplate.getForEntity(this.applyRootUriIfNecessary(url), responseType);
    }

    public HttpHeaders headForHeaders(String url, Object ... urlVariables) {
        return this.restTemplate.headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(String url, Map<String, ?> urlVariables) {
        return this.restTemplate.headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(URI url) {
        return this.restTemplate.headForHeaders(this.applyRootUriIfNecessary(url));
    }

    public URI postForLocation(String url, Object request, Object ... urlVariables) {
        return this.restTemplate.postForLocation(url, request, urlVariables);
    }

    public URI postForLocation(String url, Object request, Map<String, ?> urlVariables) {
        return this.restTemplate.postForLocation(url, request, urlVariables);
    }

    public URI postForLocation(URI url, Object request) {
        return this.restTemplate.postForLocation(this.applyRootUriIfNecessary(url), request);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Object ... urlVariables) {
        return (T)this.restTemplate.postForObject(url, request, responseType, urlVariables);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Map<String, ?> urlVariables) {
        return (T)this.restTemplate.postForObject(url, request, responseType, urlVariables);
    }

    public <T> T postForObject(URI url, Object request, Class<T> responseType) {
        return (T)this.restTemplate.postForObject(this.applyRootUriIfNecessary(url), request, responseType);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Object ... urlVariables) {
        return this.restTemplate.postForEntity(url, request, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Map<String, ?> urlVariables) {
        return this.restTemplate.postForEntity(url, request, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> postForEntity(URI url, Object request, Class<T> responseType) {
        return this.restTemplate.postForEntity(this.applyRootUriIfNecessary(url), request, responseType);
    }

    public void put(String url, Object request, Object ... urlVariables) {
        this.restTemplate.put(url, request, urlVariables);
    }

    public void put(String url, Object request, Map<String, ?> urlVariables) {
        this.restTemplate.put(url, request, urlVariables);
    }

    public void put(URI url, Object request) {
        this.restTemplate.put(this.applyRootUriIfNecessary(url), request);
    }

    public <T> T patchForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        return (T)this.restTemplate.patchForObject(url, request, responseType, uriVariables);
    }

    public <T> T patchForObject(String url, Object request, Class<T> responseType, Map<String, ?> uriVariables) {
        return (T)this.restTemplate.patchForObject(url, request, responseType, uriVariables);
    }

    public <T> T patchForObject(URI url, Object request, Class<T> responseType) {
        return (T)this.restTemplate.patchForObject(this.applyRootUriIfNecessary(url), request, responseType);
    }

    public void delete(String url, Object ... urlVariables) {
        this.restTemplate.delete(url, urlVariables);
    }

    public void delete(String url, Map<String, ?> urlVariables) {
        this.restTemplate.delete(url, urlVariables);
    }

    public void delete(URI url) {
        this.restTemplate.delete(this.applyRootUriIfNecessary(url));
    }

    public Set<HttpMethod> optionsForAllow(String url, Object ... urlVariables) {
        return this.restTemplate.optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(String url, Map<String, ?> urlVariables) {
        return this.restTemplate.optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(URI url) {
        return this.restTemplate.optionsForAllow(this.applyRootUriIfNecessary(url));
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... urlVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> urlVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType) {
        return this.restTemplate.exchange(this.applyRootUriIfNecessary(url), method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Object ... urlVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> urlVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) {
        return this.restTemplate.exchange(this.applyRootUriIfNecessary(url), method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, Class<T> responseType) {
        return this.restTemplate.exchange(this.createRequestEntityWithRootAppliedUri(requestEntity), responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) {
        return this.restTemplate.exchange(this.createRequestEntityWithRootAppliedUri(requestEntity), responseType);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Object ... urlVariables) {
        return (T)this.restTemplate.execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Map<String, ?> urlVariables) {
        return (T)this.restTemplate.execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> T execute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) {
        return (T)this.restTemplate.execute(this.applyRootUriIfNecessary(url), method, requestCallback, responseExtractor);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public TestRestTemplate withBasicAuth(String username, String password) {
        TestRestTemplate template = new TestRestTemplate(this.builder, username, password, this.httpClientOptions);
        template.setUriTemplateHandler(this.getRestTemplate().getUriTemplateHandler());
        return template;
    }

    private RequestEntity<?> createRequestEntityWithRootAppliedUri(RequestEntity<?> requestEntity) {
        return new RequestEntity(requestEntity.getBody(), (MultiValueMap)requestEntity.getHeaders(), requestEntity.getMethod(), this.applyRootUriIfNecessary(this.resolveUri(requestEntity)), requestEntity.getType());
    }

    private URI applyRootUriIfNecessary(URI uri) {
        UriTemplateHandler uriTemplateHandler = this.restTemplate.getUriTemplateHandler();
        if (uriTemplateHandler instanceof RootUriTemplateHandler) {
            RootUriTemplateHandler rootHandler = (RootUriTemplateHandler)uriTemplateHandler;
            if (uri.toString().startsWith("/")) {
                return URI.create(rootHandler.getRootUri() + uri);
            }
        }
        return uri;
    }

    private URI resolveUri(RequestEntity<?> entity) {
        if (entity instanceof RequestEntity.UriTemplateRequestEntity) {
            RequestEntity.UriTemplateRequestEntity templatedUriEntity = (RequestEntity.UriTemplateRequestEntity)entity;
            if (templatedUriEntity.getVars() != null) {
                return this.restTemplate.getUriTemplateHandler().expand(templatedUriEntity.getUriTemplate(), templatedUriEntity.getVars());
            }
            if (templatedUriEntity.getVarsMap() != null) {
                return this.restTemplate.getUriTemplateHandler().expand(templatedUriEntity.getUriTemplate(), templatedUriEntity.getVarsMap());
            }
            throw new IllegalStateException("No variables specified for URI template: " + templatedUriEntity.getUriTemplate());
        }
        return entity.getUrl();
    }

    public static enum HttpClientOption {
        ENABLE_COOKIES,
        ENABLE_REDIRECTS,
        SSL;

    }

    protected static class CustomHttpComponentsClientHttpRequestFactory
    extends HttpComponentsClientHttpRequestFactory {
        private final String cookieSpec;
        private final boolean enableRedirects;

        @Deprecated(since="3.4.0", forRemoval=true)
        public CustomHttpComponentsClientHttpRequestFactory(HttpClientOption[] httpClientOptions, org.springframework.boot.web.client.ClientHttpRequestFactorySettings settings) {
            this(httpClientOptions, new ClientHttpRequestFactorySettings(null, settings.connectTimeout(), settings.readTimeout(), settings.sslBundle()));
        }

        public CustomHttpComponentsClientHttpRequestFactory(HttpClientOption[] httpClientOptions, ClientHttpRequestFactorySettings settings) {
            HashSet<HttpClientOption> options = new HashSet<HttpClientOption>(Arrays.asList(httpClientOptions));
            this.cookieSpec = options.contains((Object)HttpClientOption.ENABLE_COOKIES) ? "strict" : "ignore";
            this.enableRedirects = options.contains((Object)HttpClientOption.ENABLE_REDIRECTS);
            boolean ssl = options.contains((Object)HttpClientOption.SSL);
            if (settings.readTimeout() != null || ssl) {
                this.setHttpClient(this.createHttpClient(settings.readTimeout(), ssl));
            }
            if (settings.connectTimeout() != null) {
                this.setConnectTimeout((int)settings.connectTimeout().toMillis());
            }
        }

        private HttpClient createHttpClient(Duration readTimeout, boolean ssl) {
            try {
                HttpClientBuilder builder = HttpClients.custom();
                builder.setConnectionManager((HttpClientConnectionManager)this.createConnectionManager(readTimeout, ssl));
                builder.setDefaultRequestConfig(this.createRequestConfig());
                return builder.build();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to create customized HttpClient", ex);
            }
        }

        private PoolingHttpClientConnectionManager createConnectionManager(Duration readTimeout, boolean ssl) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
            PoolingHttpClientConnectionManagerBuilder builder = PoolingHttpClientConnectionManagerBuilder.create();
            if (ssl) {
                builder.setTlsSocketStrategy(this.createTlsSocketStrategy());
            }
            if (readTimeout != null) {
                SocketConfig socketConfig = SocketConfig.custom().setSoTimeout((int)readTimeout.toMillis(), TimeUnit.MILLISECONDS).build();
                builder.setDefaultSocketConfig(socketConfig);
            }
            return builder.build();
        }

        private TlsSocketStrategy createTlsSocketStrategy() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            return new DefaultClientTlsStrategy(sslContext, new String[]{TLS.V_1_3.getId(), TLS.V_1_2.getId()}, null, null, null);
        }

        protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(this.createRequestConfig());
            return context;
        }

        protected RequestConfig createRequestConfig() {
            RequestConfig.Builder builder = RequestConfig.custom();
            builder.setCookieSpec(this.cookieSpec);
            builder.setAuthenticationEnabled(false);
            builder.setRedirectsEnabled(this.enableRedirects);
            return builder.build();
        }
    }

    private static final class TrustSelfSignedStrategy
    implements TrustStrategy {
        private TrustSelfSignedStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) {
            return chain.length == 1;
        }
    }
}

