/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.Comparator;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

class LifecycleVersion
implements Comparable<LifecycleVersion> {
    private static final Comparator<LifecycleVersion> COMPARATOR = Comparator.comparingInt(LifecycleVersion::getMajor).thenComparingInt(LifecycleVersion::getMinor).thenComparing(LifecycleVersion::getPatch);
    private final int major;
    private final int minor;
    private final int patch;

    LifecycleVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LifecycleVersion other = (LifecycleVersion)obj;
        boolean result = true;
        result = result && this.major == other.major;
        result = result && this.minor == other.minor;
        result = result && this.patch == other.patch;
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public String toString() {
        return "v" + this.major + "." + this.minor + "." + this.patch;
    }

    boolean isEqualOrGreaterThan(LifecycleVersion other) {
        return this.compareTo(other) >= 0;
    }

    @Override
    public int compareTo(LifecycleVersion other) {
        return COMPARATOR.compare(this, other);
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    int getPatch() {
        return this.patch;
    }

    static LifecycleVersion parse(String value) {
        Assert.hasText((String)value, (String)"'value' must not be empty");
        String withoutPrefix = value.startsWith("v") || value.startsWith("V") ? value.substring(1) : value;
        String[] components = withoutPrefix.split("\\.");
        Assert.isTrue((components.length <= 3 ? 1 : 0) != 0, () -> "'value' [%s] must be a valid version number".formatted(value));
        int[] versions = new int[3];
        for (int i = 0; i < components.length; ++i) {
            try {
                versions[i] = Integer.parseInt(components[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("'value' [" + value + "] must be a valid version number", ex);
            }
        }
        return new LifecycleVersion(versions[0], versions[1], versions[2]);
    }
}

