/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.build.BuildLog;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.ImageType;
import org.springframework.boot.buildpack.platform.build.LifecycleVersion;
import org.springframework.boot.buildpack.platform.docker.LogUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;

public abstract class AbstractBuildLog
implements BuildLog {
    @Override
    public void start(BuildRequest request) {
        this.log("Building image '" + request.getName() + "'");
        this.log();
    }

    @Override
    @Deprecated
    public Consumer<TotalProgressEvent> pullingBuilder(BuildRequest request, ImageReference imageReference) {
        return this.pullingImage(imageReference, ImageType.BUILDER);
    }

    @Override
    @Deprecated
    public void pulledBuilder(BuildRequest request, Image image) {
        this.pulledImage(image, ImageType.BUILDER);
    }

    @Override
    @Deprecated
    public Consumer<TotalProgressEvent> pullingRunImage(BuildRequest request, ImageReference imageReference) {
        return this.pullingImage(imageReference, ImageType.RUNNER);
    }

    @Override
    @Deprecated
    public void pulledRunImage(BuildRequest request, Image image) {
        this.pulledImage(image, ImageType.RUNNER);
    }

    @Override
    public Consumer<TotalProgressEvent> pullingImage(ImageReference imageReference, ImageType imageType) {
        return this.getProgressConsumer(String.format(" > Pulling %s '%s'", imageType.getDescription(), imageReference));
    }

    @Override
    public void pulledImage(Image image, ImageType imageType) {
        this.log(String.format(" > Pulled %s '%s'", imageType.getDescription(), this.getDigest(image)));
    }

    @Override
    public Consumer<TotalProgressEvent> pushingImage(ImageReference imageReference) {
        return this.getProgressConsumer(String.format(" > Pushing image '%s'", imageReference));
    }

    @Override
    public void pushedImage(ImageReference imageReference) {
        this.log(String.format(" > Pushed image '%s'", imageReference));
    }

    @Override
    public void executingLifecycle(BuildRequest request, LifecycleVersion version, VolumeName buildCacheVolume) {
        this.log(" > Executing lifecycle version " + version);
        this.log(" > Using build cache volume '" + buildCacheVolume + "'");
    }

    @Override
    public Consumer<LogUpdateEvent> runningPhase(BuildRequest request, String name) {
        this.log();
        this.log(" > Running " + name);
        String prefix = String.format("    %-14s", "[" + name + "] ");
        return event -> this.log(prefix + event);
    }

    @Override
    public void skippingPhase(String name, String reason) {
        this.log();
        this.log(" > Skipping " + name + " " + reason);
        this.log();
    }

    @Override
    public void executedLifecycle(BuildRequest request) {
        this.log();
        this.log("Successfully built image '" + request.getName() + "'");
        this.log();
    }

    private String getDigest(Image image) {
        List<String> digests = image.getDigests();
        return digests.isEmpty() ? "" : digests.get(0);
    }

    protected void log() {
        this.log("");
    }

    protected abstract void log(String var1);

    protected abstract Consumer<TotalProgressEvent> getProgressConsumer(String var1);
}

