/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.social;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.social.SocialAutoConfigurerAdapter;
import org.springframework.boot.autoconfigure.social.SocialWebAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.web.GenericConnectionStatusView;
import org.springframework.social.linkedin.api.LinkedIn;
import org.springframework.social.linkedin.connect.LinkedInConnectionFactory;
import org.springframework.web.servlet.View;

@Configuration
@ConditionalOnClass(value={SocialConfigurerAdapter.class, LinkedInConnectionFactory.class})
@ConditionalOnProperty(prefix="spring.social.linkedin.", value={"app-id"})
@AutoConfigureBefore(value={SocialWebAutoConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class LinkedInAutoConfiguration {

    @Configuration
    @EnableSocial
    @ConditionalOnWebApplication
    protected static class LinkedInAutoConfigurationAdapter
    extends SocialAutoConfigurerAdapter {
        protected LinkedInAutoConfigurationAdapter() {
        }

        @Override
        protected String getPropertyPrefix() {
            return "spring.social.linkedin.";
        }

        @Override
        protected ConnectionFactory<?> createConnectionFactory(RelaxedPropertyResolver properties) {
            return new LinkedInConnectionFactory(properties.getRequiredProperty("app-id"), properties.getRequiredProperty("app-secret"));
        }

        @Bean
        @ConditionalOnMissingBean(value={LinkedIn.class})
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public LinkedIn linkedin(ConnectionRepository repository) {
            Connection connection = repository.findPrimaryConnection(LinkedIn.class);
            return connection != null ? (LinkedIn)connection.getApi() : null;
        }

        @Bean(name={"connect/linkedinConnect", "connect/linkedinConnected"})
        @ConditionalOnProperty(prefix="spring.social.", value={"auto-connection-views"})
        public View linkedInConnectView() {
            return new GenericConnectionStatusView("linkedin", "LinkedIn");
        }
    }
}

