/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaBaseConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class, EnableTransactionManagement.class, EntityManager.class})
@Conditional(value={HibernateEntityManagerCondition.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class HibernateJpaAutoConfiguration
extends JpaBaseConfiguration {
    @Autowired
    private JpaProperties properties;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @Override
    protected AbstractJpaVendorAdapter createJpaVendorAdapter() {
        return new HibernateJpaVendorAdapter();
    }

    @Override
    protected Map<String, String> getVendorProperties() {
        return this.properties.getHibernateProperties(this.dataSource);
    }

    static class HibernateEntityManagerCondition
    extends SpringBootCondition {
        private static String[] CLASS_NAMES = new String[]{"org.hibernate.ejb.HibernateEntityManager", "org.hibernate.jpa.HibernateEntityManager"};

        HibernateEntityManagerCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            for (String className : CLASS_NAMES) {
                if (!ClassUtils.isPresent((String)className, (ClassLoader)context.getClassLoader())) continue;
                return ConditionOutcome.match("found HibernateEntityManager class");
            }
            return ConditionOutcome.noMatch("did not find HibernateEntityManager class");
        }
    }
}

