/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnPropertyCondition
extends SpringBootCondition {
    OnPropertyCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String prefix = ((String)metadata.getAnnotationAttributes(ConditionalOnProperty.class.getName()).get("prefix")).trim();
        if (!"".equals(prefix) && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String[] names = (String[])metadata.getAnnotationAttributes(ConditionalOnProperty.class.getName()).get("value");
        Boolean relaxedNames = (Boolean)metadata.getAnnotationAttributes(ConditionalOnProperty.class.getName()).get("relaxedNames");
        ArrayList<String> missingProperties = new ArrayList<String>();
        Environment resolver = context.getEnvironment();
        if (relaxedNames.booleanValue()) {
            resolver = new RelaxedPropertyResolver((PropertyResolver)resolver, prefix);
            prefix = "";
        }
        for (String name : names) {
            name = prefix + name;
            if (resolver.containsProperty(name) && !"false".equalsIgnoreCase(resolver.getProperty(name))) continue;
            missingProperties.add(name);
        }
        if (missingProperties.isEmpty()) {
            return ConditionOutcome.match();
        }
        return ConditionOutcome.noMatch("@ConditionalOnProperty missing required properties: " + StringUtils.arrayToCommaDelimitedString((Object[])missingProperties.toArray()) + " not found");
    }
}

