/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.env;

import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.env.EnvironmentEndpoint;

@EndpointWebExtension(endpoint=EnvironmentEndpoint.class)
public class EnvironmentEndpointWebExtension {
    private final EnvironmentEndpoint delegate;
    private final Show showValues;
    private final Set<String> roles;

    public EnvironmentEndpointWebExtension(EnvironmentEndpoint delegate, Show showValues, Set<String> roles) {
        this.delegate = delegate;
        this.showValues = showValues;
        this.roles = roles;
    }

    @ReadOperation
    public EnvironmentEndpoint.EnvironmentDescriptor environment(SecurityContext securityContext, @Nullable String pattern) {
        boolean showUnsanitized = this.showValues.isShown(securityContext, this.roles);
        return this.delegate.getEnvironmentDescriptor(pattern, showUnsanitized);
    }

    @ReadOperation
    public WebEndpointResponse<EnvironmentEndpoint.EnvironmentEntryDescriptor> environmentEntry(SecurityContext securityContext, @Selector String toMatch) {
        boolean showUnsanitized = this.showValues.isShown(securityContext, this.roles);
        EnvironmentEndpoint.EnvironmentEntryDescriptor descriptor = this.delegate.getEnvironmentEntryDescriptor(toMatch, showUnsanitized);
        return descriptor.getProperty() != null ? new WebEndpointResponse<EnvironmentEndpoint.EnvironmentEntryDescriptor>(descriptor, 200) : new WebEndpointResponse<int>(404);
    }
}

