/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.context.properties;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetadata;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Endpoint(id="configprops")
public class ConfigurationPropertiesReportEndpoint
implements ApplicationContextAware {
    private static final String CONFIGURATION_PROPERTIES_FILTER_ID = "configurationPropertiesFilter";
    private final Sanitizer sanitizer = new Sanitizer();
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        this.sanitizer.setKeysToSanitize(keysToSanitize);
    }

    @ReadOperation
    public ApplicationConfigurationProperties configurationProperties() {
        return this.extract(this.context);
    }

    private ApplicationConfigurationProperties extract(ApplicationContext context) {
        ObjectMapper mapper = new ObjectMapper();
        this.configureObjectMapper(mapper);
        HashMap<String, ContextConfigurationProperties> contextProperties = new HashMap<String, ContextConfigurationProperties>();
        for (ApplicationContext target = context; target != null; target = target.getParent()) {
            contextProperties.put(target.getId(), this.describeConfigurationProperties(target, mapper));
        }
        return new ApplicationConfigurationProperties(contextProperties);
    }

    private ContextConfigurationProperties describeConfigurationProperties(ApplicationContext context, ObjectMapper mapper) {
        ConfigurationBeanFactoryMetadata beanFactoryMetadata = this.getBeanFactoryMetadata(context);
        Map<String, Object> beans = this.getConfigurationPropertiesBeans(context, beanFactoryMetadata);
        HashMap<String, ConfigurationPropertiesBeanDescriptor> beanDescriptors = new HashMap<String, ConfigurationPropertiesBeanDescriptor>();
        for (Map.Entry<String, Object> entry : beans.entrySet()) {
            String beanName = entry.getKey();
            Object bean = entry.getValue();
            String prefix = this.extractPrefix(context, beanFactoryMetadata, beanName);
            beanDescriptors.put(beanName, new ConfigurationPropertiesBeanDescriptor(prefix, this.sanitize(prefix, this.safeSerialize(mapper, bean, prefix))));
        }
        return new ContextConfigurationProperties(beanDescriptors, context.getParent() == null ? null : context.getParent().getId());
    }

    private ConfigurationBeanFactoryMetadata getBeanFactoryMetadata(ApplicationContext context) {
        Map beans = context.getBeansOfType(ConfigurationBeanFactoryMetadata.class);
        if (beans.size() == 1) {
            return (ConfigurationBeanFactoryMetadata)beans.values().iterator().next();
        }
        return null;
    }

    private Map<String, Object> getConfigurationPropertiesBeans(ApplicationContext context, ConfigurationBeanFactoryMetadata beanFactoryMetadata) {
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.putAll(context.getBeansWithAnnotation(ConfigurationProperties.class));
        if (beanFactoryMetadata != null) {
            beans.putAll(beanFactoryMetadata.getBeansWithFactoryAnnotation(ConfigurationProperties.class));
        }
        return beans;
    }

    private Map<String, Object> safeSerialize(ObjectMapper mapper, Object bean, String prefix) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>((Map)mapper.convertValue(bean, Map.class));
            return result;
        }
        catch (Exception ex) {
            return new HashMap<String, Object>(Collections.singletonMap("error", "Cannot serialize '" + prefix + "'"));
        }
    }

    protected void configureObjectMapper(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.applyConfigurationPropertiesFilter(mapper);
        this.applySerializationModifier(mapper);
    }

    private void applySerializationModifier(ObjectMapper mapper) {
        SerializerFactory factory = BeanSerializerFactory.instance.withSerializerModifier((BeanSerializerModifier)new GenericSerializerModifier());
        mapper.setSerializerFactory(factory);
    }

    private void applyConfigurationPropertiesFilter(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new ConfigurationPropertiesAnnotationIntrospector());
        mapper.setFilterProvider((FilterProvider)new SimpleFilterProvider().setDefaultFilter((SimpleBeanPropertyFilter)new ConfigurationPropertiesPropertyFilter()));
    }

    private String extractPrefix(ApplicationContext context, ConfigurationBeanFactoryMetadata beanFactoryMetaData, String beanName) {
        ConfigurationProperties override;
        ConfigurationProperties annotation = (ConfigurationProperties)context.findAnnotationOnBean(beanName, ConfigurationProperties.class);
        if (beanFactoryMetaData != null && (override = (ConfigurationProperties)beanFactoryMetaData.findFactoryAnnotation(beanName, ConfigurationProperties.class)) != null) {
            annotation = override;
        }
        return annotation.prefix();
    }

    private Map<String, Object> sanitize(String prefix, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            String qualifiedKey = (prefix.isEmpty() ? prefix : prefix + ".") + key;
            Object value = entry.getValue();
            if (value instanceof Map) {
                map.put(key, this.sanitize(qualifiedKey, (Map)value));
                continue;
            }
            if (value instanceof List) {
                map.put(key, this.sanitize(qualifiedKey, (List)value));
                continue;
            }
            value = this.sanitizer.sanitize(key, value);
            value = this.sanitizer.sanitize(qualifiedKey, value);
            map.put(key, value);
        }
        return map;
    }

    private List<Object> sanitize(String prefix, List<Object> list) {
        ArrayList<Object> sanitized = new ArrayList<Object>();
        for (Object item : list) {
            if (item instanceof Map) {
                sanitized.add(this.sanitize(prefix, (Map)item));
                continue;
            }
            if (item instanceof List) {
                sanitized.add(this.sanitize(prefix, (List)item));
                continue;
            }
            sanitized.add(this.sanitizer.sanitize(prefix, item));
        }
        return sanitized;
    }

    public static final class ConfigurationPropertiesBeanDescriptor {
        private final String prefix;
        private final Map<String, Object> properties;

        private ConfigurationPropertiesBeanDescriptor(String prefix, Map<String, Object> properties) {
            this.prefix = prefix;
            this.properties = properties;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    public static final class ContextConfigurationProperties {
        private final Map<String, ConfigurationPropertiesBeanDescriptor> beans;
        private final String parentId;

        private ContextConfigurationProperties(Map<String, ConfigurationPropertiesBeanDescriptor> beans, String parentId) {
            this.beans = beans;
            this.parentId = parentId;
        }

        public Map<String, ConfigurationPropertiesBeanDescriptor> getBeans() {
            return this.beans;
        }

        public String getParentId() {
            return this.parentId;
        }
    }

    public static final class ApplicationConfigurationProperties {
        private final Map<String, ContextConfigurationProperties> contexts;

        private ApplicationConfigurationProperties(Map<String, ContextConfigurationProperties> contexts) {
            this.contexts = contexts;
        }

        public Map<String, ContextConfigurationProperties> getContexts() {
            return this.contexts;
        }
    }

    protected static class GenericSerializerModifier
    extends BeanSerializerModifier {
        protected GenericSerializerModifier() {
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
            for (BeanPropertyWriter writer : beanProperties) {
                boolean readable = this.isReadable(beanDesc, writer);
                if (!readable) continue;
                result.add(writer);
            }
            return result;
        }

        private boolean isReadable(BeanDescription beanDesc, BeanPropertyWriter writer) {
            Class parentType = beanDesc.getType().getRawClass();
            Class type = writer.getType().getRawClass();
            AnnotatedMethod setter = this.findSetter(beanDesc, writer);
            return setter != null || ClassUtils.getPackageName((Class)parentType).equals(ClassUtils.getPackageName((Class)type)) || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
        }

        private AnnotatedMethod findSetter(BeanDescription beanDesc, BeanPropertyWriter writer) {
            Class type;
            String name = "set" + StringUtils.capitalize((String)writer.getName());
            AnnotatedMethod setter = beanDesc.findMethod(name, new Class[]{type = writer.getType().getRawClass()});
            if (setter == null && type.equals(Boolean.TYPE)) {
                setter = beanDesc.findMethod(name, new Class[]{Boolean.class});
            }
            return setter;
        }
    }

    private static class ConfigurationPropertiesPropertyFilter
    extends SimpleBeanPropertyFilter {
        private static final Log logger = LogFactory.getLog(ConfigurationPropertiesPropertyFilter.class);

        private ConfigurationPropertiesPropertyFilter() {
        }

        protected boolean include(BeanPropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        protected boolean include(PropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        private boolean include(String name) {
            return !name.startsWith("$$");
        }

        public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
            if (writer instanceof BeanPropertyWriter) {
                try {
                    if (pojo == ((BeanPropertyWriter)writer).get(pojo)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Skipping '" + writer.getFullName() + "' on '" + pojo.getClass().getName() + "' as it is self-referential"));
                        }
                        return;
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Skipping '" + writer.getFullName() + "' on '" + pojo.getClass().getName() + "' as an exception was thrown when retrieving its value"), (Throwable)ex);
                    }
                    return;
                }
            }
            super.serializeAsField(pojo, jgen, provider, writer);
        }
    }

    private static class ConfigurationPropertiesAnnotationIntrospector
    extends JacksonAnnotationIntrospector {
        private ConfigurationPropertiesAnnotationIntrospector() {
        }

        public Object findFilterId(Annotated a) {
            Object id = super.findFilterId(a);
            if (id == null) {
                id = ConfigurationPropertiesReportEndpoint.CONFIGURATION_PROPERTIES_FILTER_ID;
            }
            return id;
        }
    }
}

