/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.zipkin;

import brave.Tag;
import brave.Tags;
import brave.handler.MutableSpan;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import java.net.http.HttpClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.PropertiesZipkinConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinHttpClientBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinHttpClientSender;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinProperties;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinRestTemplateBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinRestTemplateSender;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinWebClientBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinWebClientSender;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import zipkin2.Span;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.HttpEndpointSupplier;
import zipkin2.reporter.HttpEndpointSuppliers;
import zipkin2.reporter.SpanBytesEncoder;
import zipkin2.reporter.brave.AsyncZipkinSpanHandler;
import zipkin2.reporter.brave.MutableSpanBytesEncoder;
import zipkin2.reporter.urlconnection.URLConnectionSender;

class ZipkinConfigurations {
    ZipkinConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanExporter.class, Span.class})
    static class OpenTelemetryConfiguration {
        OpenTelemetryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Span.class}, parameterizedContainer={BytesEncoder.class})
        BytesEncoder<Span> spanBytesEncoder(Encoding encoding) {
            return SpanBytesEncoder.forEncoding((Encoding)encoding);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={BytesMessageSender.class})
        @ConditionalOnEnabledTracing
        ZipkinSpanExporter zipkinSpanExporter(BytesMessageSender sender, BytesEncoder<Span> spanBytesEncoder) {
            return ZipkinSpanExporter.builder().setSender(sender).setEncoder(spanBytesEncoder).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={AsyncZipkinSpanHandler.class})
    static class BraveConfiguration {
        BraveConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={MutableSpan.class}, parameterizedContainer={BytesEncoder.class})
        BytesEncoder<MutableSpan> mutableSpanBytesEncoder(Encoding encoding, ObjectProvider<Tag<Throwable>> throwableTagProvider) {
            Tag throwableTag = (Tag)throwableTagProvider.getIfAvailable(() -> Tags.ERROR);
            return MutableSpanBytesEncoder.create((Encoding)encoding, (Tag)throwableTag);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={BytesMessageSender.class})
        @ConditionalOnEnabledTracing
        AsyncZipkinSpanHandler asyncZipkinSpanHandler(BytesMessageSender sender, BytesEncoder<MutableSpan> mutableSpanBytesEncoder) {
            return AsyncZipkinSpanHandler.newBuilder((BytesMessageSender)sender).build(mutableSpanBytesEncoder);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class HttpClientSenderConfiguration {
        HttpClientSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={BytesMessageSender.class})
        ZipkinHttpClientSender httpClientSender(ZipkinProperties properties, Encoding encoding, ObjectProvider<ZipkinHttpClientBuilderCustomizer> customizers, ObjectProvider<ZipkinConnectionDetails> connectionDetailsProvider, ObjectProvider<HttpEndpointSupplier.Factory> endpointSupplierFactoryProvider) {
            ZipkinConnectionDetails connectionDetails = (ZipkinConnectionDetails)connectionDetailsProvider.getIfAvailable(() -> new PropertiesZipkinConnectionDetails(properties));
            HttpEndpointSupplier.Factory endpointSupplierFactory = (HttpEndpointSupplier.Factory)endpointSupplierFactoryProvider.getIfAvailable(HttpEndpointSuppliers::constantFactory);
            HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().connectTimeout(properties.getConnectTimeout());
            customizers.orderedStream().forEach(customizer -> customizer.customize(httpClientBuilder));
            return new ZipkinHttpClientSender(encoding, endpointSupplierFactory, connectionDetails.getSpanEndpoint(), httpClientBuilder.build(), properties.getReadTimeout());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebClient.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class WebClientSenderConfiguration {
        WebClientSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={BytesMessageSender.class})
        ZipkinWebClientSender webClientSender(ZipkinProperties properties, Encoding encoding, ObjectProvider<ZipkinWebClientBuilderCustomizer> customizers, ObjectProvider<ZipkinConnectionDetails> connectionDetailsProvider, ObjectProvider<HttpEndpointSupplier.Factory> endpointSupplierFactoryProvider) {
            ZipkinConnectionDetails connectionDetails = (ZipkinConnectionDetails)connectionDetailsProvider.getIfAvailable(() -> new PropertiesZipkinConnectionDetails(properties));
            HttpEndpointSupplier.Factory endpointSupplierFactory = (HttpEndpointSupplier.Factory)endpointSupplierFactoryProvider.getIfAvailable(HttpEndpointSuppliers::constantFactory);
            WebClient.Builder builder = WebClient.builder();
            customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return new ZipkinWebClientSender(encoding, endpointSupplierFactory, connectionDetails.getSpanEndpoint(), builder.build(), properties.getConnectTimeout().plus(properties.getReadTimeout()));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestTemplate.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class RestTemplateSenderConfiguration {
        RestTemplateSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={BytesMessageSender.class})
        ZipkinRestTemplateSender restTemplateSender(ZipkinProperties properties, Encoding encoding, ObjectProvider<ZipkinRestTemplateBuilderCustomizer> customizers, ObjectProvider<ZipkinConnectionDetails> connectionDetailsProvider, ObjectProvider<HttpEndpointSupplier.Factory> endpointSupplierFactoryProvider) {
            ZipkinConnectionDetails connectionDetails = (ZipkinConnectionDetails)connectionDetailsProvider.getIfAvailable(() -> new PropertiesZipkinConnectionDetails(properties));
            HttpEndpointSupplier.Factory endpointSupplierFactory = (HttpEndpointSupplier.Factory)endpointSupplierFactoryProvider.getIfAvailable(HttpEndpointSuppliers::constantFactory);
            RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(properties.getConnectTimeout()).setReadTimeout(properties.getReadTimeout());
            restTemplateBuilder = this.applyCustomizers(restTemplateBuilder, customizers);
            return new ZipkinRestTemplateSender(encoding, endpointSupplierFactory, connectionDetails.getSpanEndpoint(), restTemplateBuilder.build());
        }

        private RestTemplateBuilder applyCustomizers(RestTemplateBuilder restTemplateBuilder, ObjectProvider<ZipkinRestTemplateBuilderCustomizer> customizers) {
            Iterable orderedCustomizers = () -> customizers.orderedStream().iterator();
            RestTemplateBuilder currentBuilder = restTemplateBuilder;
            for (ZipkinRestTemplateBuilderCustomizer customizer : orderedCustomizers) {
                currentBuilder = customizer.customize(currentBuilder);
            }
            return currentBuilder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={URLConnectionSender.class})
    @EnableConfigurationProperties(value={ZipkinProperties.class})
    static class UrlConnectionSenderConfiguration {
        UrlConnectionSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={BytesMessageSender.class})
        URLConnectionSender urlConnectionSender(ZipkinProperties properties, Encoding encoding, ObjectProvider<ZipkinConnectionDetails> connectionDetailsProvider, ObjectProvider<HttpEndpointSupplier.Factory> endpointSupplierFactoryProvider) {
            ZipkinConnectionDetails connectionDetails = (ZipkinConnectionDetails)connectionDetailsProvider.getIfAvailable(() -> new PropertiesZipkinConnectionDetails(properties));
            HttpEndpointSupplier.Factory endpointSupplierFactory = (HttpEndpointSupplier.Factory)endpointSupplierFactoryProvider.getIfAvailable(HttpEndpointSuppliers::constantFactory);
            URLConnectionSender.Builder builder = URLConnectionSender.newBuilder();
            builder.connectTimeout((int)properties.getConnectTimeout().toMillis());
            builder.readTimeout((int)properties.getReadTimeout().toMillis());
            builder.endpointSupplierFactory(endpointSupplierFactory);
            builder.endpoint(connectionDetails.getSpanEndpoint());
            builder.encoding(encoding);
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={UrlConnectionSenderConfiguration.class, WebClientSenderConfiguration.class, RestTemplateSenderConfiguration.class, HttpClientSenderConfiguration.class})
    static class SenderConfiguration {
        SenderConfiguration() {
        }
    }
}

