/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.health.HealthProperties;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="management.endpoint.health")
public class HealthEndpointProperties
extends HealthProperties {
    private Show showDetails = Show.NEVER;
    private final Map<String, Group> group = new LinkedHashMap<String, Group>();
    private final Logging logging = new Logging();

    @Override
    public Show getShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(Show showDetails) {
        this.showDetails = showDetails;
    }

    public Map<String, Group> getGroup() {
        return this.group;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public static class Logging {
        private Duration slowIndicatorThreshold = Duration.ofSeconds(10L);

        public Duration getSlowIndicatorThreshold() {
            return this.slowIndicatorThreshold;
        }

        public void setSlowIndicatorThreshold(Duration slowIndicatorThreshold) {
            this.slowIndicatorThreshold = slowIndicatorThreshold;
        }
    }

    public static class Group
    extends HealthProperties {
        public static final String SERVER_PREFIX = "server:";
        public static final String MANAGEMENT_PREFIX = "management:";
        private Set<String> include;
        private Set<String> exclude;
        private Show showDetails;
        private String additionalPath;

        public Set<String> getInclude() {
            return this.include;
        }

        public void setInclude(Set<String> include) {
            this.include = include;
        }

        public Set<String> getExclude() {
            return this.exclude;
        }

        public void setExclude(Set<String> exclude) {
            this.exclude = exclude;
        }

        @Override
        public Show getShowDetails() {
            return this.showDetails;
        }

        public void setShowDetails(Show showDetails) {
            this.showDetails = showDetails;
        }

        public String getAdditionalPath() {
            return this.additionalPath;
        }

        public void setAdditionalPath(String additionalPath) {
            this.additionalPath = additionalPath;
        }
    }
}

