/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.SpanCustomizer;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.exporter.SpanExportingPredicate;
import io.micrometer.tracing.exporter.SpanFilter;
import io.micrometer.tracing.exporter.SpanReporter;
import io.micrometer.tracing.otel.bridge.CompositeSpanExporter;
import io.micrometer.tracing.otel.bridge.EventListener;
import io.micrometer.tracing.otel.bridge.EventPublishingContextWrapper;
import io.micrometer.tracing.otel.bridge.OtelBaggageManager;
import io.micrometer.tracing.otel.bridge.OtelCurrentTraceContext;
import io.micrometer.tracing.otel.bridge.OtelPropagator;
import io.micrometer.tracing.otel.bridge.OtelSpanCustomizer;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.micrometer.tracing.otel.bridge.Slf4JBaggageEventListener;
import io.micrometer.tracing.otel.bridge.Slf4JEventListener;
import io.micrometer.tracing.otel.propagation.BaggageTextMapPropagator;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.MicrometerTracingAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.tracing.SdkTracerProviderBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@AutoConfiguration(before={MicrometerTracingAutoConfiguration.class})
@ConditionalOnEnabledTracing
@ConditionalOnClass(value={OtelTracer.class, SdkTracerProvider.class, OpenTelemetry.class})
@EnableConfigurationProperties(value={TracingProperties.class})
public class OpenTelemetryAutoConfiguration {
    private static final String DEFAULT_APPLICATION_NAME = "application";
    private final TracingProperties tracingProperties;

    OpenTelemetryAutoConfiguration(TracingProperties tracingProperties) {
        this.tracingProperties = tracingProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    OpenTelemetry openTelemetry(SdkTracerProvider sdkTracerProvider, ContextPropagators contextPropagators) {
        return OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(contextPropagators).build();
    }

    @Bean
    @ConditionalOnMissingBean
    SdkTracerProvider otelSdkTracerProvider(Environment environment, ObjectProvider<SpanProcessor> spanProcessors, Sampler sampler, ObjectProvider<SdkTracerProviderBuilderCustomizer> customizers) {
        String applicationName = environment.getProperty("spring.application.name", DEFAULT_APPLICATION_NAME);
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder().setSampler(sampler).setResource(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)applicationName)));
        spanProcessors.orderedStream().forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    ContextPropagators otelContextPropagators(ObjectProvider<TextMapPropagator> textMapPropagators) {
        return ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite(textMapPropagators.orderedStream().toList()));
    }

    @Bean
    @ConditionalOnMissingBean
    Sampler otelSampler() {
        Sampler rootSampler = Sampler.traceIdRatioBased((double)this.tracingProperties.getSampling().getProbability());
        return Sampler.parentBased((Sampler)rootSampler);
    }

    @Bean
    SpanProcessor otelSpanProcessor(ObjectProvider<SpanExporter> spanExporters, ObjectProvider<SpanExportingPredicate> spanExportingPredicates, ObjectProvider<SpanReporter> spanReporters, ObjectProvider<SpanFilter> spanFilters) {
        return BatchSpanProcessor.builder((SpanExporter)new CompositeSpanExporter(spanExporters.orderedStream().toList(), spanExportingPredicates.orderedStream().toList(), spanReporters.orderedStream().toList(), spanFilters.orderedStream().toList())).build();
    }

    @Bean
    @ConditionalOnMissingBean
    io.opentelemetry.api.trace.Tracer otelTracer(OpenTelemetry openTelemetry) {
        return openTelemetry.getTracer("org.springframework.boot", SpringBootVersion.getVersion());
    }

    @Bean
    @ConditionalOnMissingBean(value={Tracer.class})
    OtelTracer micrometerOtelTracer(io.opentelemetry.api.trace.Tracer tracer, OtelTracer.EventPublisher eventPublisher, OtelCurrentTraceContext otelCurrentTraceContext) {
        return new OtelTracer(tracer, otelCurrentTraceContext, eventPublisher, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)otelCurrentTraceContext, this.tracingProperties.getBaggage().getRemoteFields(), Collections.emptyList()));
    }

    @Bean
    @ConditionalOnMissingBean
    OtelPropagator otelPropagator(ContextPropagators contextPropagators, io.opentelemetry.api.trace.Tracer tracer) {
        return new OtelPropagator(contextPropagators, tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    OtelTracer.EventPublisher otelTracerEventPublisher(List<EventListener> eventListeners) {
        return new OTelEventPublisher(eventListeners);
    }

    @Bean
    @ConditionalOnMissingBean
    OtelCurrentTraceContext otelCurrentTraceContext(OtelTracer.EventPublisher publisher) {
        ContextStorage.addWrapper((Function)new EventPublishingContextWrapper(publisher));
        return new OtelCurrentTraceContext();
    }

    @Bean
    @ConditionalOnMissingBean
    Slf4JEventListener otelSlf4JEventListener() {
        return new Slf4JEventListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={SpanCustomizer.class})
    OtelSpanCustomizer otelSpanCustomizer() {
        return new OtelSpanCustomizer();
    }

    static class OTelEventPublisher
    implements OtelTracer.EventPublisher {
        private final List<EventListener> listeners;

        OTelEventPublisher(List<EventListener> listeners) {
            this.listeners = listeners;
        }

        public void publishEvent(Object event) {
            for (EventListener listener : this.listeners) {
                listener.onEvent(event);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="management.tracing.baggage", name={"enabled"}, havingValue="false")
    static class NoBaggageConfiguration {
        NoBaggageConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="management.tracing.propagation", name={"type"}, havingValue="B3")
        B3Propagator b3TextMapPropagator() {
            return B3Propagator.injectingSingleHeader();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="management.tracing.propagation", name={"type"}, havingValue="W3C", matchIfMissing=true)
        W3CTraceContextPropagator w3cTextMapPropagatorWithoutBaggage() {
            return W3CTraceContextPropagator.getInstance();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="management.tracing.baggage", name={"enabled"}, matchIfMissing=true)
    static class BaggageConfiguration {
        private final TracingProperties tracingProperties;

        BaggageConfiguration(TracingProperties tracingProperties) {
            this.tracingProperties = tracingProperties;
        }

        @Bean
        @ConditionalOnProperty(prefix="management.tracing.propagation", name={"type"}, havingValue="W3C", matchIfMissing=true)
        TextMapPropagator w3cTextMapPropagatorWithBaggage(OtelCurrentTraceContext otelCurrentTraceContext) {
            List<String> remoteFields = this.tracingProperties.getBaggage().getRemoteFields();
            return TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance(), new BaggageTextMapPropagator(remoteFields, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)otelCurrentTraceContext, remoteFields, Collections.emptyList()))});
        }

        @Bean
        @ConditionalOnProperty(prefix="management.tracing.propagation", name={"type"}, havingValue="B3")
        TextMapPropagator b3BaggageTextMapPropagator(OtelCurrentTraceContext otelCurrentTraceContext) {
            List<String> remoteFields = this.tracingProperties.getBaggage().getRemoteFields();
            return TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{B3Propagator.injectingSingleHeader(), new BaggageTextMapPropagator(remoteFields, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)otelCurrentTraceContext, remoteFields, Collections.emptyList()))});
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="management.tracing.baggage.correlation", name={"enabled"}, matchIfMissing=true)
        Slf4JBaggageEventListener otelSlf4JBaggageEventListener() {
            return new Slf4JBaggageEventListener(this.tracingProperties.getBaggage().getCorrelation().getFields());
        }
    }
}

