/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import brave.CurrentSpanCustomizer;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.TracingCustomizer;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.baggage.CorrelationScopeConfig;
import brave.baggage.CorrelationScopeCustomizer;
import brave.baggage.CorrelationScopeDecorator;
import brave.context.slf4j.MDCScopeDecorator;
import brave.handler.SpanHandler;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.CurrentTraceContextCustomizer;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BraveBaggageManager;
import io.micrometer.tracing.brave.bridge.BraveCurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BravePropagator;
import io.micrometer.tracing.brave.bridge.BraveSpanCustomizer;
import io.micrometer.tracing.brave.bridge.BraveTracer;
import io.micrometer.tracing.brave.bridge.CompositeSpanHandler;
import io.micrometer.tracing.brave.bridge.W3CPropagation;
import io.micrometer.tracing.exporter.SpanExportingPredicate;
import io.micrometer.tracing.exporter.SpanFilter;
import io.micrometer.tracing.exporter.SpanReporter;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.MicrometerTracingAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@AutoConfiguration(before={MicrometerTracingAutoConfiguration.class})
@ConditionalOnClass(value={Tracer.class, BraveTracer.class})
@EnableConfigurationProperties(value={TracingProperties.class})
@ConditionalOnEnabledTracing
public class BraveAutoConfiguration {
    private static final BraveBaggageManager BRAVE_BAGGAGE_MANAGER = new BraveBaggageManager();
    private static final String DEFAULT_APPLICATION_NAME = "application";

    @Bean
    @ConditionalOnMissingBean
    @Order(value=-2147483648)
    CompositeSpanHandler compositeSpanHandler(ObjectProvider<SpanExportingPredicate> predicates, ObjectProvider<SpanReporter> reporters, ObjectProvider<SpanFilter> filters) {
        return new CompositeSpanHandler(predicates.orderedStream().toList(), reporters.orderedStream().toList(), filters.orderedStream().toList());
    }

    @Bean
    @ConditionalOnMissingBean
    public Tracing braveTracing(Environment environment, List<SpanHandler> spanHandlers, List<TracingCustomizer> tracingCustomizers, brave.propagation.CurrentTraceContext currentTraceContext, Propagation.Factory propagationFactory, Sampler sampler) {
        String applicationName = environment.getProperty("spring.application.name", DEFAULT_APPLICATION_NAME);
        Tracing.Builder builder = Tracing.newBuilder().currentTraceContext(currentTraceContext).traceId128Bit(true).supportsJoin(false).propagationFactory(propagationFactory).sampler(sampler).localServiceName(applicationName);
        spanHandlers.forEach(arg_0 -> ((Tracing.Builder)builder).addSpanHandler(arg_0));
        for (TracingCustomizer tracingCustomizer : tracingCustomizers) {
            tracingCustomizer.customize(builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Tracer braveTracer(Tracing tracing) {
        return tracing.tracer();
    }

    @Bean
    @ConditionalOnMissingBean
    public brave.propagation.CurrentTraceContext braveCurrentTraceContext(List<CurrentTraceContext.ScopeDecorator> scopeDecorators, List<CurrentTraceContextCustomizer> currentTraceContextCustomizers) {
        ThreadLocalCurrentTraceContext.Builder builder = ThreadLocalCurrentTraceContext.newBuilder();
        scopeDecorators.forEach(arg_0 -> ((ThreadLocalCurrentTraceContext.Builder)builder).addScopeDecorator(arg_0));
        for (CurrentTraceContextCustomizer currentTraceContextCustomizer : currentTraceContextCustomizers) {
            currentTraceContextCustomizer.customize((CurrentTraceContext.Builder)builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Sampler braveSampler(TracingProperties properties) {
        return Sampler.create((float)properties.getSampling().getProbability());
    }

    @Bean
    @ConditionalOnMissingBean(value={io.micrometer.tracing.Tracer.class})
    BraveTracer braveTracerBridge(Tracer tracer, brave.propagation.CurrentTraceContext currentTraceContext) {
        return new BraveTracer(tracer, (CurrentTraceContext)new BraveCurrentTraceContext(currentTraceContext), (BaggageManager)BRAVE_BAGGAGE_MANAGER);
    }

    @Bean
    @ConditionalOnMissingBean
    BravePropagator bravePropagator(Tracing tracing) {
        return new BravePropagator(tracing);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpanCustomizer.class})
    CurrentSpanCustomizer currentSpanCustomizer(Tracing tracing) {
        return CurrentSpanCustomizer.create((Tracing)tracing);
    }

    @Bean
    @ConditionalOnMissingBean(value={io.micrometer.tracing.SpanCustomizer.class})
    BraveSpanCustomizer braveSpanCustomizer(SpanCustomizer spanCustomizer) {
        return new BraveSpanCustomizer(spanCustomizer);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"management.tracing.baggage.enabled"}, matchIfMissing=true)
    static class BraveBaggageConfiguration {
        private final TracingProperties tracingProperties;

        BraveBaggageConfiguration(TracingProperties tracingProperties) {
            this.tracingProperties = tracingProperties;
        }

        @Bean
        @ConditionalOnMissingBean
        BaggagePropagation.FactoryBuilder propagationFactoryBuilder(ObjectProvider<BaggagePropagationCustomizer> baggagePropagationCustomizers) {
            W3CPropagation delegate = switch (this.tracingProperties.getPropagation().getType()) {
                default -> throw new IncompatibleClassChangeError();
                case TracingProperties.Propagation.PropagationType.B3 -> B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();
                case TracingProperties.Propagation.PropagationType.W3C -> new W3CPropagation((BaggageManager)BRAVE_BAGGAGE_MANAGER, Collections.emptyList());
            };
            BaggagePropagation.FactoryBuilder builder = BaggagePropagation.newFactoryBuilder((Propagation.Factory)delegate);
            baggagePropagationCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder;
        }

        @Bean
        @Order(value=0)
        BaggagePropagationCustomizer remoteFieldsBaggagePropagationCustomizer() {
            return builder -> {
                List<String> remoteFields = this.tracingProperties.getBaggage().getRemoteFields();
                for (String fieldName : remoteFields) {
                    builder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)BaggageField.create((String)fieldName)));
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean
        Propagation.Factory propagationFactory(BaggagePropagation.FactoryBuilder factoryBuilder) {
            return factoryBuilder.build();
        }

        @Bean
        @ConditionalOnMissingBean
        CorrelationScopeDecorator.Builder mdcCorrelationScopeDecoratorBuilder(ObjectProvider<CorrelationScopeCustomizer> correlationScopeCustomizers) {
            CorrelationScopeDecorator.Builder builder = MDCScopeDecorator.newBuilder();
            correlationScopeCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder;
        }

        @Bean
        @Order(value=0)
        @ConditionalOnProperty(prefix="management.tracing.baggage.correlation", name={"enabled"}, matchIfMissing=true)
        CorrelationScopeCustomizer correlationFieldsCorrelationScopeCustomizer() {
            return builder -> {
                List<String> correlationFields = this.tracingProperties.getBaggage().getCorrelation().getFields();
                for (String field : correlationFields) {
                    builder.add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageField.create((String)field)).flushOnUpdate().build());
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean(value={CorrelationScopeDecorator.class})
        CurrentTraceContext.ScopeDecorator correlationScopeDecorator(CorrelationScopeDecorator.Builder builder) {
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"management.tracing.baggage.enabled"}, havingValue="false")
    static class BraveNoBaggageConfiguration {
        BraveNoBaggageConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        Propagation.Factory propagationFactory(TracingProperties tracing) {
            return switch (tracing.getPropagation().getType()) {
                default -> throw new IncompatibleClassChangeError();
                case TracingProperties.Propagation.PropagationType.B3 -> B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();
                case TracingProperties.Propagation.PropagationType.W3C -> new W3CPropagation();
            };
        }
    }
}

