/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Condition;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@Endpoint(id="conditions")
public class ConditionsReportEndpoint {
    private final ConfigurableApplicationContext context;

    public ConditionsReportEndpoint(ConfigurableApplicationContext context) {
        this.context = context;
    }

    @ReadOperation
    public ApplicationConditionEvaluation applicationConditionEvaluation() {
        HashMap<String, ContextConditionEvaluation> contextConditionEvaluations = new HashMap<String, ContextConditionEvaluation>();
        ConfigurableApplicationContext target = this.context;
        while (target != null) {
            contextConditionEvaluations.put(target.getId(), new ContextConditionEvaluation(target));
            target = this.getConfigurableParent(target);
        }
        return new ApplicationConditionEvaluation(contextConditionEvaluations);
    }

    private ConfigurableApplicationContext getConfigurableParent(ConfigurableApplicationContext context) {
        ApplicationContext parent = context.getParent();
        if (parent instanceof ConfigurableApplicationContext) {
            return (ConfigurableApplicationContext)parent;
        }
        return null;
    }

    @JsonPropertyOrder(value={"condition", "message"})
    public static class MessageAndCondition {
        private final String condition;
        private final String message;

        public MessageAndCondition(ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome) {
            Condition condition = conditionAndOutcome.getCondition();
            ConditionOutcome outcome = conditionAndOutcome.getOutcome();
            this.condition = ClassUtils.getShortName(condition.getClass());
            this.message = StringUtils.hasLength((String)outcome.getMessage()) ? outcome.getMessage() : (outcome.isMatch() ? "matched" : "did not match");
        }

        public String getCondition() {
            return this.condition;
        }

        public String getMessage() {
            return this.message;
        }
    }

    @JsonPropertyOrder(value={"notMatched", "matched"})
    public static class MessageAndConditions {
        private final List<MessageAndCondition> notMatched = new ArrayList<MessageAndCondition>();
        private final List<MessageAndCondition> matched = new ArrayList<MessageAndCondition>();

        public MessageAndConditions(ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
            for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
                List<MessageAndCondition> target = conditionAndOutcome.getOutcome().isMatch() ? this.matched : this.notMatched;
                target.add(new MessageAndCondition(conditionAndOutcome));
            }
        }

        public List<MessageAndCondition> getNotMatched() {
            return this.notMatched;
        }

        public List<MessageAndCondition> getMatched() {
            return this.matched;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static final class ContextConditionEvaluation {
        private final MultiValueMap<String, MessageAndCondition> positiveMatches;
        private final Map<String, MessageAndConditions> negativeMatches;
        private final List<String> exclusions;
        private final Set<String> unconditionalClasses;
        private final String parentId;

        public ContextConditionEvaluation(ConfigurableApplicationContext context) {
            ConditionEvaluationReport report = ConditionEvaluationReport.get((ConfigurableListableBeanFactory)context.getBeanFactory());
            this.positiveMatches = new LinkedMultiValueMap();
            this.negativeMatches = new LinkedHashMap<String, MessageAndConditions>();
            this.exclusions = report.getExclusions();
            this.unconditionalClasses = report.getUnconditionalClasses();
            for (Map.Entry entry : report.getConditionAndOutcomesBySource().entrySet()) {
                if (((ConditionEvaluationReport.ConditionAndOutcomes)entry.getValue()).isFullMatch()) {
                    this.add(this.positiveMatches, (String)entry.getKey(), (ConditionEvaluationReport.ConditionAndOutcomes)entry.getValue());
                    continue;
                }
                this.add(this.negativeMatches, (String)entry.getKey(), (ConditionEvaluationReport.ConditionAndOutcomes)entry.getValue());
            }
            this.parentId = context.getParent() == null ? null : context.getParent().getId();
        }

        private void add(Map<String, MessageAndConditions> map, String source, ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
            String name = ClassUtils.getShortName((String)source);
            map.put(name, new MessageAndConditions(conditionAndOutcomes));
        }

        private void add(MultiValueMap<String, MessageAndCondition> map, String source, ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
            String name = ClassUtils.getShortName((String)source);
            for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
                map.add((Object)name, (Object)new MessageAndCondition(conditionAndOutcome));
            }
        }

        public Map<String, List<MessageAndCondition>> getPositiveMatches() {
            return this.positiveMatches;
        }

        public Map<String, MessageAndConditions> getNegativeMatches() {
            return this.negativeMatches;
        }

        public List<String> getExclusions() {
            return this.exclusions;
        }

        public Set<String> getUnconditionalClasses() {
            return this.unconditionalClasses;
        }

        public String getParentId() {
            return this.parentId;
        }
    }

    public static final class ApplicationConditionEvaluation {
        private final Map<String, ContextConditionEvaluation> contexts;

        private ApplicationConditionEvaluation(Map<String, ContextConditionEvaluation> contexts) {
            this.contexts = contexts;
        }

        public Map<String, ContextConditionEvaluation> getContexts() {
            return this.contexts;
        }
    }
}

