/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springdoc.core.customizers.DataRestRouterOperationCustomizer;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.customizers.GlobalOperationCustomizer;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.customizers.RouterOperationCustomizer;
import org.springdoc.core.filters.GlobalOpenApiMethodFilter;
import org.springdoc.core.filters.OpenApiMethodFilter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class SpringDocCustomizers
implements ApplicationContextAware,
InitializingBean {
    private final Optional<List<OpenApiCustomizer>> openApiCustomizers;
    private final Optional<List<OperationCustomizer>> operationCustomizers;
    private final Optional<List<RouterOperationCustomizer>> routerOperationCustomizers;
    private final Optional<List<DataRestRouterOperationCustomizer>> dataRestRouterOperationCustomizers;
    private ApplicationContext context;
    private final Optional<List<OpenApiMethodFilter>> methodFilters;
    private Optional<List<GlobalOpenApiCustomizer>> globalOpenApiCustomizers;
    private Optional<List<GlobalOperationCustomizer>> globalOperationCustomizers;
    private Optional<List<GlobalOpenApiMethodFilter>> globalOpenApiMethodFilters;

    public SpringDocCustomizers(Optional<List<OpenApiCustomizer>> openApiCustomizers, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<RouterOperationCustomizer>> routerOperationCustomizers, Optional<List<DataRestRouterOperationCustomizer>> dataRestRouterOperationCustomizers, Optional<List<OpenApiMethodFilter>> methodFilters, Optional<List<GlobalOpenApiCustomizer>> globalOpenApiCustomizers, Optional<List<GlobalOperationCustomizer>> globalOperationCustomizers, Optional<List<GlobalOpenApiMethodFilter>> globalOpenApiMethodFilters) {
        this.openApiCustomizers = openApiCustomizers;
        this.operationCustomizers = operationCustomizers;
        this.globalOpenApiCustomizers = globalOpenApiCustomizers;
        this.globalOperationCustomizers = globalOperationCustomizers;
        this.globalOpenApiMethodFilters = globalOpenApiMethodFilters;
        operationCustomizers.ifPresent(customizers -> customizers.removeIf(Objects::isNull));
        this.routerOperationCustomizers = routerOperationCustomizers;
        this.dataRestRouterOperationCustomizers = dataRestRouterOperationCustomizers;
        this.methodFilters = methodFilters;
    }

    public SpringDocCustomizers(Optional<List<OpenApiCustomizer>> openApiCustomizers, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<RouterOperationCustomizer>> routerOperationCustomizers, Optional<List<OpenApiMethodFilter>> openApiMethodFilters) {
        this.openApiCustomizers = openApiCustomizers;
        this.operationCustomizers = operationCustomizers;
        this.routerOperationCustomizers = routerOperationCustomizers;
        this.methodFilters = openApiMethodFilters;
        this.dataRestRouterOperationCustomizers = Optional.empty();
    }

    public Optional<List<OpenApiCustomizer>> getOpenApiCustomizers() {
        return this.openApiCustomizers;
    }

    public Optional<List<OperationCustomizer>> getOperationCustomizers() {
        return this.operationCustomizers;
    }

    public Optional<List<RouterOperationCustomizer>> getRouterOperationCustomizers() {
        return this.routerOperationCustomizers;
    }

    public Optional<List<DataRestRouterOperationCustomizer>> getDataRestRouterOperationCustomizers() {
        return this.dataRestRouterOperationCustomizers;
    }

    public Optional<List<OpenApiMethodFilter>> getMethodFilters() {
        return this.methodFilters;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public Optional<List<GlobalOpenApiCustomizer>> getGlobalOpenApiCustomizers() {
        return this.globalOpenApiCustomizers;
    }

    public Optional<List<GlobalOperationCustomizer>> getGlobalOperationCustomizers() {
        return this.globalOperationCustomizers;
    }

    public Optional<List<GlobalOpenApiMethodFilter>> getGlobalOpenApiMethodFilters() {
        return this.globalOpenApiMethodFilters;
    }

    public void afterPropertiesSet() {
        Map existingOpenApiCustomizers = this.context.getBeansOfType(OpenApiCustomizer.class);
        if (!CollectionUtils.isEmpty((Map)existingOpenApiCustomizers) && existingOpenApiCustomizers.containsKey("linksSchemaCustomizer")) {
            this.openApiCustomizers.ifPresent(openApiCustomizersList -> openApiCustomizersList.add((OpenApiCustomizer)existingOpenApiCustomizers.get("linksSchemaCustomizer")));
        }
    }
}

