/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.util.List;
import org.sonar.graph.Edge;

public class Cycle {
    private Edge[] edges;
    private int hashcode = 0;

    public Cycle(List<Edge> edges) {
        this.edges = edges.toArray(new Edge[edges.size()]);
        for (Edge edge : edges) {
            this.hashcode += edge.hashCode();
        }
    }

    public int size() {
        return this.edges.length;
    }

    public boolean contains(Edge e) {
        for (Edge edge : this.edges) {
            if (!edge.equals(e)) continue;
            return true;
        }
        return false;
    }

    public Edge[] getEdges() {
        return this.edges;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Cycle with " + this.size() + " edges : ");
        for (Edge edge : this.edges) {
            builder.append(edge.getFrom()).append(" -> ");
        }
        return builder.toString();
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object object) {
        if (object instanceof Cycle) {
            Cycle otherCycle = (Cycle)object;
            if (otherCycle.hashcode == this.hashcode && otherCycle.edges.length == this.edges.length) {
                block0: for (Edge otherEdge : otherCycle.edges) {
                    for (Edge edge : this.edges) {
                        if (otherEdge.equals(edge)) continue block0;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

