/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Proxy;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.LogOutput;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;

public class ScannerFactory {
    private final LogOutput logOutput;
    private final RuntimeInformation runtimeInformation;
    private final MavenSession session;
    private final boolean debugEnabled;
    private final PropertyDecryptor propertyDecryptor;
    private final Properties envProps;
    private final Log log;
    private final MojoExecution mojoExecution;

    public ScannerFactory(LogOutput logOutput, Log log, RuntimeInformation runtimeInformation, MojoExecution mojoExecution, MavenSession session, Properties envProps, PropertyDecryptor propertyDecryptor) {
        this.logOutput = logOutput;
        this.log = log;
        this.runtimeInformation = runtimeInformation;
        this.mojoExecution = mojoExecution;
        this.session = session;
        this.debugEnabled = log.isDebugEnabled();
        this.envProps = envProps;
        this.propertyDecryptor = propertyDecryptor;
    }

    public EmbeddedScanner create() {
        this.setProxySystemProperties();
        EmbeddedScanner scanner = EmbeddedScanner.create((LogOutput)this.logOutput);
        scanner.setApp("ScannerMaven", this.mojoExecution.getVersion() + "/" + this.runtimeInformation.getMavenVersion());
        scanner.addGlobalProperties(this.createGlobalProperties());
        scanner.setGlobalProperty("sonar.mojoUseRunner", "true");
        if (this.debugEnabled) {
            scanner.setGlobalProperty("sonar.verbose", "true");
        }
        return scanner;
    }

    public Properties createGlobalProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.session.getCurrentProject().getProperties());
        p.putAll((Map<?, ?>)this.envProps);
        p.putAll((Map<?, ?>)this.session.getSystemProperties());
        p.putAll((Map<?, ?>)this.session.getUserProperties());
        p.putAll((Map<?, ?>)this.propertyDecryptor.decryptProperties(p));
        return p;
    }

    public void setProxySystemProperties() {
        Proxy activeProxy = this.session.getSettings().getActiveProxy();
        if (activeProxy != null && activeProxy.getProtocol() != null && activeProxy.getProtocol().contains("http")) {
            this.log.debug((CharSequence)"Setting proxy properties");
            System.setProperty("http.proxyHost", activeProxy.getHost());
            System.setProperty("http.proxyPort", String.valueOf(activeProxy.getPort()));
            System.setProperty("http.proxyUser", StringUtils.defaultString((String)activeProxy.getUsername(), (String)""));
            System.setProperty("http.proxyPassword", StringUtils.defaultString((String)activeProxy.getPassword(), (String)""));
            System.setProperty("http.nonProxyHosts", StringUtils.defaultString((String)activeProxy.getNonProxyHosts(), (String)""));
        }
    }
}

