/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.mailer.EmailTooBigException;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.converter.EmailConverter;
import org.simplejavamail.converter.internal.mimemessage.ImmutableDelegatingSMTPMessage;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerHelper;
import org.simplejavamail.email.internal.InternalEmail;
import org.simplejavamail.internal.moduleloader.ModuleLoader;
import org.simplejavamail.mailer.internal.MailerException;
import org.simplejavamail.mailer.internal.MailerImpl;
import org.simplejavamail.mailer.internal.util.MessageIdFixingMimeMessage;
import org.simplejavamail.mailer.internal.util.SessionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBasedEmailToMimeMessageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailerImpl.class);
    private static final String MIMEMESSAGE_CONVERTER_KEY = "SESSION_BASED_EMAIL_TO_MIME_MESSAGE_CONVERTER_KEY";
    private final Session session;
    private final OperationalConfig operationalConfig;
    private final EmailGovernance emailGovernance;

    public static void primeSession(Session session, OperationalConfig operationalConfig, EmailGovernance emailGovernance) {
        session.getProperties().put(MIMEMESSAGE_CONVERTER_KEY, new SessionBasedEmailToMimeMessageConverter(session, operationalConfig, emailGovernance));
    }

    public static void unprimeSession(@NotNull Session session) {
        session.getProperties().remove(MIMEMESSAGE_CONVERTER_KEY);
    }

    @NotNull
    public static MimeMessage convertAndLogMimeMessage(Session session, Email email) throws MessagingException {
        int emailSize;
        SessionBasedEmailToMimeMessageConverter mimeMessageConverter = (SessionBasedEmailToMimeMessageConverter)session.getProperties().get(MIMEMESSAGE_CONVERTER_KEY);
        MimeMessage mimeMessage = mimeMessageConverter.convertAndLogMimeMessage(email);
        EmailGovernance governance = mimeMessageConverter.emailGovernance;
        if (governance.getMaximumEmailSize() != null && (emailSize = SessionBasedEmailToMimeMessageConverter.calculateEmailSize(mimeMessage)) > governance.getMaximumEmailSize()) {
            throw new EmailTooBigException((long)emailSize, (long)governance.getMaximumEmailSize().intValue());
        }
        return mimeMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int calculateEmailSize(MimeMessage mimeMessage) throws MessagingException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            mimeMessage.writeTo((OutputStream)os);
            int n = os.size();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("error trying to calculate email size", e);
        }
    }

    @NotNull
    private MimeMessage convertAndLogMimeMessage(Email email) throws MessagingException {
        MimeMessage message = SessionBasedEmailToMimeMessageConverter.convertMimeMessage(email, this.session);
        SessionLogger.logSession(this.session, this.operationalConfig.isAsync(), "mail");
        if (!SessionBasedEmailToMimeMessageConverter.messageIsProperlyWrappedForCustomMessageId(message)) {
            throw new AssertionError((Object)"Wrong MimeMessage type; would be unable to fix Message-ID on message.saveChanges()");
        }
        message.saveChanges();
        ((InternalEmail)email).updateId(message.getMessageID());
        SessionBasedEmailToMimeMessageConverter.logEmail(message, this.operationalConfig.isTransportModeLoggingOnly(), email);
        return message;
    }

    private static boolean messageIsProperlyWrappedForCustomMessageId(MimeMessage message) {
        return message instanceof MessageIdFixingMimeMessage || message instanceof ImmutableDelegatingSMTPMessage || ModuleLoader.dkimModuleAvailable() && ModuleLoader.loadDKIMModule().isMessageIdFixingMessage(message) || ModuleLoader.smimeModuleAvailable() && ModuleLoader.loadSmimeModule().isMessageIdFixingMessage(message);
    }

    private static MimeMessage convertMimeMessage(Email email, Session session) throws MessagingException {
        try {
            return MimeMessageProducerHelper.produceMimeMessage(email, session);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.trace("Failed to send email {}\n{}", (Object)email.getId(), (Object)email);
            throw new MailerException(String.format("Failed to send email [%s], reason: Encoding not accepted", email.getId()), e);
        }
    }

    private static void logEmail(MimeMessage message, boolean transportModeLoggingOnly, Email email) {
        if (transportModeLoggingOnly) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\n\nEmail: {}\n", (Object)email);
                LOGGER.info("\n\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("\t\nEmail: {}", (Object)email);
            LOGGER.trace("\t\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
        }
    }

    public SessionBasedEmailToMimeMessageConverter(Session session, OperationalConfig operationalConfig, EmailGovernance emailGovernance) {
        this.session = session;
        this.operationalConfig = operationalConfig;
        this.emailGovernance = emailGovernance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionBasedEmailToMimeMessageConverter)) {
            return false;
        }
        SessionBasedEmailToMimeMessageConverter other = (SessionBasedEmailToMimeMessageConverter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Session this$session = this.session;
        Session other$session = other.session;
        if (this$session == null ? other$session != null : !this$session.equals(other$session)) {
            return false;
        }
        OperationalConfig this$operationalConfig = this.operationalConfig;
        OperationalConfig other$operationalConfig = other.operationalConfig;
        if (this$operationalConfig == null ? other$operationalConfig != null : !this$operationalConfig.equals(other$operationalConfig)) {
            return false;
        }
        EmailGovernance this$emailGovernance = this.emailGovernance;
        EmailGovernance other$emailGovernance = other.emailGovernance;
        return !(this$emailGovernance == null ? other$emailGovernance != null : !this$emailGovernance.equals(other$emailGovernance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SessionBasedEmailToMimeMessageConverter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Session $session = this.session;
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        OperationalConfig $operationalConfig = this.operationalConfig;
        result = result * 59 + ($operationalConfig == null ? 43 : $operationalConfig.hashCode());
        EmailGovernance $emailGovernance = this.emailGovernance;
        result = result * 59 + ($emailGovernance == null ? 43 : $emailGovernance.hashCode());
        return result;
    }

    public String toString() {
        return "SessionBasedEmailToMimeMessageConverter(session=" + this.session + ", operationalConfig=" + this.operationalConfig + ", emailGovernance=" + this.emailGovernance + ")";
    }
}

