/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.Bytes;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyUtil;

public class WikittyHBaseUtil {
    private static Log log = LogFactory.getLog(WikittyHBaseUtil.class);
    public static final byte[] T_EXTENSION = Bytes.toBytes((String)"extension");
    public static final byte[] T_WIKITTY = Bytes.toBytes((String)"wikitty");
    public static final byte[] F_ADMIN = Bytes.toBytes((String)"admin");
    public static final byte[] F_DATA = Bytes.toBytes((String)"data");
    public static final byte[] Q_EXTENSION = Bytes.toBytes((String)"extension");
    public static final byte[] Q_VERSION = Bytes.toBytes((String)"version");
    public static final byte[] Q_REQUIRES = Bytes.toBytes((String)"requires");
    public static final byte[] Q_TAGVALUES = Bytes.toBytes((String)"tagvalues");
    public static final byte[] Q_ID = Bytes.toBytes((String)"id");
    public static final byte[] Q_NAME = Bytes.toBytes((String)"name");
    public static final byte[] Q_DELETE_DATE = Bytes.toBytes((String)"deleteDate");
    public static final byte[] NULL = Bytes.toBytes((String)"null_3525743624876732845");
    public static final String HBASE_CLIENT_RETRIES_NUMBER = "hbase.client.retries.number";
    public static final String HBASE_CLIENT_PAUSE = "hbase.client.pause";
    protected static HBaseConfiguration conf = new HBaseConfiguration();

    public static HBaseConfiguration getHBaseConfiguration() {
        if (conf == null) {
            conf = new HBaseConfiguration();
            conf.set(HBASE_CLIENT_PAUSE, "1000");
            conf.set(HBASE_CLIENT_RETRIES_NUMBER, "5");
        }
        return conf;
    }

    public static byte[] toBytes(Object obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
            bos.close();
            byte[] data = bos.toByteArray();
            return data;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public static Object fromBytes(byte[] obj) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(obj);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object object = ois.readObject();
            ois.close();
            bis.close();
            return object;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public static byte[] toBytes(FieldType field, Object o) {
        byte[] result = null;
        switch (field.getType()) {
            case BOOLEAN: {
                if (Boolean.TRUE.equals(o)) {
                    result = Bytes.toBytes((int)1);
                    break;
                }
                result = Bytes.toBytes((int)0);
                break;
            }
            case DATE: {
                result = Bytes.toBytes((long)WikittyUtil.toDate((Object)o).getTime());
                break;
            }
            case NUMERIC: {
                result = Bytes.toBytes((String)WikittyUtil.toBigDecimal((Object)o).toString());
                break;
            }
            case STRING: {
                result = Bytes.toBytes((String)String.valueOf(o));
                break;
            }
            default: {
                result = Bytes.toBytes((String)String.valueOf(o));
            }
        }
        return result;
    }

    public static Object fromBytes(FieldType field, byte[] b) {
        Object result = null;
        switch (field.getType()) {
            case BOOLEAN: {
                result = Bytes.toInt((byte[])b) != 0;
                break;
            }
            case DATE: {
                long date = Bytes.toLong((byte[])b);
                result = new Date(date);
                break;
            }
            case NUMERIC: {
                String val = Bytes.toString((byte[])b);
                result = new BigDecimal(val);
                break;
            }
            case STRING: {
                result = Bytes.toString((byte[])b);
                break;
            }
            default: {
                result = Bytes.toString((byte[])b);
            }
        }
        return result;
    }
}

