/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class SingleEntryAsyncQueue<T> {
    public static final long MILLISECONDS = 1000L;
    private static final Logger log = Logger.getLogger(SingleEntryAsyncQueue.class.getName());
    private final AtomicReference<T> poisonData;
    private final long timeoutInSeconds;
    private final ArrayBlockingQueue<T> holder;

    public SingleEntryAsyncQueue(long timeoutInSecs) {
        this.timeoutInSeconds = timeoutInSecs;
        this.holder = new ArrayBlockingQueue(1);
        this.poisonData = new AtomicReference();
    }

    public long getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    protected void setPoison(T poisonInstance) {
        this.poisonData.set(poisonInstance);
    }

    protected boolean isPoison(T poisonSample) {
        T poison = this.poisonData.get();
        return null != poison && poison.equals(poisonSample);
    }

    protected T pollToGetContentUntilTimeout() {
        T result = this.holder.poll();
        if (null != result) {
            log.fine("data was waiting: " + result);
            return result;
        }
        if (this.timeoutInSeconds <= 0L) {
            return null;
        }
        long deadline = System.currentTimeMillis() + this.timeoutInSeconds * 1000L;
        long now = System.currentTimeMillis();
        while (now < deadline) {
            try {
                log.fine("waiting for data for at most " + this.timeoutInSeconds + " more s");
                result = this.holder.poll(deadline - now, TimeUnit.MILLISECONDS);
                log.fine("data from polling: " + result);
                return result;
            }
            catch (InterruptedException ie) {
                log.fine("was interrupted; resuming wait");
                now = System.currentTimeMillis();
            }
        }
        return null;
    }

    protected boolean putContent(T thing) {
        log.fine("putting command: " + thing);
        boolean result = this.holder.offer(thing);
        log.fine("..command put?: " + result);
        return result;
    }

    protected boolean isEmpty() {
        return 0 == this.holder.size();
    }

    protected T peek() {
        return this.holder.peek();
    }

    protected boolean poisonPollers() {
        if (null == this.poisonData.get()) {
            this.holder.clear();
            return false;
        }
        this.putContent(this.poisonData.get());
        return true;
    }
}

