/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.renderer;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.server.HttpRequest;
import org.openqa.selenium.remote.server.HttpResponse;
import org.openqa.selenium.remote.server.rest.Renderer;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class JsonResult
implements Renderer {
    protected final String propertyName;

    public JsonResult(String propertyName) {
        this.propertyName = propertyName.startsWith(":") ? propertyName.substring(1) : propertyName;
    }

    @Override
    public void render(HttpRequest request, HttpResponse response, RestishHandler handler) throws Exception {
        Object result = request.getAttribute(this.propertyName);
        String json = new BeanToJsonConverter().convert(result);
        ByteBuffer bb = Charsets.UTF_8.encode(json);
        byte[] data = new byte[bb.remaining()];
        bb.get(data);
        response.setContentType("application/json");
        response.setEncoding(Charsets.UTF_8);
        response.setContent(data);
        response.end();
    }
}

