/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class GridDocHelper {
    private static Properties gridProperties = GridDocHelper.load("org/openqa/grid/common/defaults/GridParameters.properties");

    public static void printHelp(String msg) {
        GridDocHelper.printHelpInConsole(gridProperties, msg, true);
    }

    public static void printHelp(String msg, boolean error) {
        GridDocHelper.printHelpInConsole(gridProperties, msg, error);
    }

    public static String getGridParam(String param) {
        return GridDocHelper.getParam(gridProperties, param);
    }

    private static String getParam(Properties p, String param) {
        if (param == null) {
            return "";
        }
        String s = (String)gridProperties.get(param);
        if (s == null) {
            return "No help specified for " + param;
        }
        return s;
    }

    private static void printHelpInConsole(Properties p, String msg, boolean error) {
        String indent = "  ";
        String indent2x = indent + indent;
        if (msg != null) {
            if (error) {
                System.out.println("Error building the config :" + msg);
            } else {
                System.out.println(msg);
            }
        }
        System.out.println("Usage :");
        for (Object key : p.keySet()) {
            System.out.println(indent + "-" + key + ":\t");
            GridDocHelper.printWrappedErrorLine(indent2x, GridDocHelper.getParam(p, key.toString()), true);
            System.out.println("");
        }
    }

    public static void printWrappedErrorLine(String prefix, String msg, boolean first) {
        int defaultWrap;
        int wrap;
        System.err.print(prefix);
        if (!first) {
            System.err.print("  ");
        }
        if ((wrap = (defaultWrap = 70) - prefix.length()) > msg.length()) {
            System.err.println(msg);
            return;
        }
        String lineRaw = msg.substring(0, wrap);
        int spaceIndex = lineRaw.lastIndexOf(32);
        if (spaceIndex == -1) {
            spaceIndex = lineRaw.length();
        }
        String line = lineRaw.substring(0, spaceIndex);
        System.err.println(line);
        GridDocHelper.printWrappedErrorLine(prefix, msg.substring(spaceIndex + 1), false);
    }

    private static Properties load(String resource) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        Properties p = new Properties();
        if (in != null) {
            try {
                p.load(in);
                return p;
            }
            catch (IOException e) {
                throw new RuntimeException(resource + " cannot be loaded.");
            }
        }
        throw new RuntimeException(resource + " cannot be loaded.");
    }
}

