/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.OsProcess;
import org.openqa.selenium.os.UnixProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    private static final Method JDK6_CAN_EXECUTE = CommandLine.findJdk6CanExecuteMethod();
    private OsProcess process;

    public CommandLine(String executable, String ... args) {
        this.process = new UnixProcess(executable, args);
    }

    public CommandLine(String[] cmdarray) {
        String executable = cmdarray[0];
        int length = cmdarray.length - 1;
        String[] args = new String[length];
        System.arraycopy(cmdarray, 1, args, 0, length);
        this.process = new UnixProcess(executable, args);
    }

    @VisibleForTesting
    Map<String, String> getEnvironment() {
        return this.process.getEnvironment();
    }

    public void setEnvironmentVariables(Map<String, String> environment) {
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            this.setEnvironmentVariable(entry.getKey(), entry.getValue());
        }
    }

    public void setEnvironmentVariable(String name, String value) {
        this.process.setEnvironmentVariable(name, value);
    }

    public void setDynamicLibraryPath(String newLibraryPath) {
        if (newLibraryPath != null) {
            this.setEnvironmentVariable(CommandLine.getLibraryPathPropertyName(), newLibraryPath);
        }
    }

    public static String getLibraryPathPropertyName() {
        switch (Platform.getCurrent()) {
            case MAC: {
                return "DYLD_LIBRARY_PATH";
            }
            case WINDOWS: 
            case VISTA: 
            case XP: {
                return "PATH";
            }
        }
        return "LD_LIBRARY_PATH";
    }

    public static String findExecutable(String named) {
        File file = new File(named);
        if (CommandLine.canExecute(file)) {
            return named;
        }
        Map<String, String> env = System.getenv();
        String pathName = "PATH";
        if (!env.containsKey("PATH")) {
            for (String key : env.keySet()) {
                if (!"path".equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        String path = env.get(pathName);
        String[] endings = new String[]{""};
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            endings = new String[]{"", ".exe", ".com", ".bat"};
        }
        for (String segment : path.split(File.pathSeparator)) {
            for (String ending : endings) {
                file = new File(segment, named + ending);
                if (!CommandLine.canExecute(file)) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    public void executeAsync() {
        this.process.executeAsync();
    }

    public void execute() {
        this.executeAsync();
        this.waitFor();
    }

    public void waitFor() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public boolean isSuccessful() {
        return 0 == this.getExitCode();
    }

    public int getExitCode() {
        return this.process.getExitCode();
    }

    public String getStdOut() {
        return this.process.getStdOut();
    }

    public int destroy() {
        return this.process.destroy();
    }

    private static boolean canExecute(File file) {
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        if (JDK6_CAN_EXECUTE != null) {
            try {
                return (Boolean)JDK6_CAN_EXECUTE.invoke((Object)file, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return true;
    }

    private static Method findJdk6CanExecuteMethod() {
        try {
            return File.class.getMethod("canExecute", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public void setInput(String allInput) {
        this.process.setInput(allInput);
    }

    public String toString() {
        return this.process.toString();
    }

    public void copyOutputTo(OutputStream out) {
        this.process.copyOutputTo(out);
    }
}

