/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.html5;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.remote.ExecuteMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteSessionStorage
implements SessionStorage {
    private final ExecuteMethod executeMethod;

    public RemoteSessionStorage(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    public String getItem(String key) {
        ImmutableMap args = ImmutableMap.of((Object)"key", (Object)key);
        return (String)this.executeMethod.execute("getSessionStorageItem", (Map<String, ?>)args);
    }

    public Set<String> keySet() {
        Collection result = (Collection)this.executeMethod.execute("getSessionStorageKey", null);
        return new HashSet<String>(result);
    }

    public void setItem(String key, String value) {
        ImmutableMap args = ImmutableMap.of((Object)"key", (Object)key, (Object)"value", (Object)value);
        this.executeMethod.execute("setSessionStorageItem", (Map<String, ?>)args);
    }

    public String removeItem(String key) {
        ImmutableMap args = ImmutableMap.of((Object)"key", (Object)key);
        return (String)this.executeMethod.execute("removeSessionStorageItem", (Map<String, ?>)args);
    }

    public void clear() {
        this.executeMethod.execute("clearSessionStorage", null);
    }

    public int size() {
        Object response = this.executeMethod.execute("getSessionStorageSize", null);
        return Integer.parseInt(response.toString());
    }
}

