/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.thoughtworks.selenium.Selenium;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.internal.selenesedriver.AbstractElementFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindElements
extends AbstractElementFinder<List<Map<String, String>>> {
    private static final String SCRIPT = "selenium.browserbot.findElementsLikeWebDriver('%s', '%s', %s);";

    @Override
    protected List<Map<String, String>> executeFind(Selenium selenium, String how, String using, String parentLocator) {
        String result = selenium.getEval(String.format(SCRIPT, how, using, parentLocator));
        Iterable allKeys = Splitter.on((String)",").split((CharSequence)result);
        ArrayList toReturn = Lists.newArrayList();
        for (String key : allKeys) {
            toReturn.add(this.newElement(key));
        }
        return toReturn;
    }

    @Override
    protected List<Map<String, String>> onFailure(String how, String using) {
        return Lists.newArrayList();
    }
}

