/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v143.network.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v143.network.model.AssociatedCookie;
import org.openqa.selenium.devtools.v143.network.model.ClientSecurityState;
import org.openqa.selenium.devtools.v143.network.model.ConnectTiming;
import org.openqa.selenium.devtools.v143.network.model.Headers;
import org.openqa.selenium.devtools.v143.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RequestWillBeSentExtraInfo {
    private final RequestId requestId;
    private final List<AssociatedCookie> associatedCookies;
    private final Headers headers;
    private final ConnectTiming connectTiming;
    private final Optional<ClientSecurityState> clientSecurityState;
    private final Optional<Boolean> siteHasCookieInOtherPartition;
    private final Optional<String> appliedNetworkConditionsId;

    public RequestWillBeSentExtraInfo(RequestId requestId, List<AssociatedCookie> associatedCookies, Headers headers, ConnectTiming connectTiming, Optional<ClientSecurityState> clientSecurityState, Optional<Boolean> siteHasCookieInOtherPartition, Optional<String> appliedNetworkConditionsId) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.associatedCookies = Objects.requireNonNull(associatedCookies, "associatedCookies is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.connectTiming = Objects.requireNonNull(connectTiming, "connectTiming is required");
        this.clientSecurityState = clientSecurityState;
        this.siteHasCookieInOtherPartition = siteHasCookieInOtherPartition;
        this.appliedNetworkConditionsId = appliedNetworkConditionsId;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public List<AssociatedCookie> getAssociatedCookies() {
        return this.associatedCookies;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    @Beta
    public ConnectTiming getConnectTiming() {
        return this.connectTiming;
    }

    public Optional<ClientSecurityState> getClientSecurityState() {
        return this.clientSecurityState;
    }

    public Optional<Boolean> getSiteHasCookieInOtherPartition() {
        return this.siteHasCookieInOtherPartition;
    }

    public Optional<String> getAppliedNetworkConditionsId() {
        return this.appliedNetworkConditionsId;
    }

    private static RequestWillBeSentExtraInfo fromJson(JsonInput input) {
        RequestId requestId = null;
        List associatedCookies = null;
        Headers headers = null;
        ConnectTiming connectTiming = null;
        Optional<ClientSecurityState> clientSecurityState = Optional.empty();
        Optional<Boolean> siteHasCookieInOtherPartition = Optional.empty();
        Optional<String> appliedNetworkConditionsId = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block18;
                }
                case "associatedCookies": {
                    associatedCookies = input.readArray(AssociatedCookie.class);
                    continue block18;
                }
                case "headers": {
                    headers = (Headers)input.read(Headers.class);
                    continue block18;
                }
                case "connectTiming": {
                    connectTiming = (ConnectTiming)input.read(ConnectTiming.class);
                    continue block18;
                }
                case "clientSecurityState": {
                    clientSecurityState = Optional.ofNullable((ClientSecurityState)input.read(ClientSecurityState.class));
                    continue block18;
                }
                case "siteHasCookieInOtherPartition": {
                    siteHasCookieInOtherPartition = Optional.ofNullable(input.nextBoolean());
                    continue block18;
                }
                case "appliedNetworkConditionsId": {
                    appliedNetworkConditionsId = Optional.ofNullable(input.nextString());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestWillBeSentExtraInfo(requestId, associatedCookies, headers, connectTiming, clientSecurityState, siteHasCookieInOtherPartition, appliedNetworkConditionsId);
    }
}

